/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.auth;

import io.camunda.search.exception.CamundaSearchException;
import io.camunda.security.auth.Authorization;
import io.camunda.security.auth.CamundaAuthentication;
import io.camunda.security.auth.SecurityContext;
import io.camunda.security.impl.AuthorizationChecker;
import io.camunda.security.reader.ResourceAccess;
import io.camunda.security.reader.ResourceAccessProvider;
import io.camunda.zeebe.protocol.record.value.AuthorizationScope;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class DefaultResourceAccessProvider
implements ResourceAccessProvider {
    private final AuthorizationChecker authorizationChecker;

    public DefaultResourceAccessProvider(AuthorizationChecker authorizationChecker) {
        this.authorizationChecker = authorizationChecker;
    }

    public <T> ResourceAccess resolveResourceAccess(CamundaAuthentication authentication, Authorization<T> requiredAuthorization) {
        Authorization.Builder resultingAuthorization = new Authorization.Builder().resourceType(requiredAuthorization.resourceType()).permissionType(requiredAuthorization.permissionType());
        SecurityContext securityContext = this.createSecurityContext(authentication, requiredAuthorization);
        List authorizationScopes = this.authorizationChecker.retrieveAuthorizedAuthorizationScopes(securityContext);
        if (authorizationScopes.contains(AuthorizationScope.WILDCARD)) {
            return ResourceAccess.wildcard((Authorization)resultingAuthorization.resourceId(AuthorizationScope.WILDCARD.getResourceId()).build());
        }
        if (authorizationScopes.isEmpty()) {
            return ResourceAccess.denied((Authorization)resultingAuthorization.build());
        }
        List<String> resourceIds = authorizationScopes.stream().map(AuthorizationScope::getResourceId).distinct().toList();
        Authorization authorizationWithResolvedResourceIds = resultingAuthorization.resourceIds(resourceIds).build();
        return ResourceAccess.allowed((Authorization)authorizationWithResolvedResourceIds);
    }

    public <T> ResourceAccess hasResourceAccess(CamundaAuthentication authentication, Authorization<T> requiredAuthorization, T resource) {
        Function resourceIdSupplier = requiredAuthorization.resourceIdSupplier();
        List resourceIds = requiredAuthorization.resourceIds();
        String resourceId = Optional.ofNullable(resourceIdSupplier).map(supplier -> (String)supplier.apply(resource)).orElseGet(() -> Optional.ofNullable(resourceIds).filter(l -> l.size() == 1).map(List::getFirst).orElseThrow(() -> new CamundaSearchException("Expected one resource id to check resource access, but received none or more than one")));
        return this.hasResourceAccessByResourceId(authentication, requiredAuthorization, resourceId);
    }

    public <T> ResourceAccess hasResourceAccessByResourceId(CamundaAuthentication authentication, Authorization<T> requiredAuthorization, String resourceId) {
        SecurityContext securityContext = this.createSecurityContext(authentication, requiredAuthorization);
        boolean isAuthorized = this.authorizationChecker.isAuthorized(AuthorizationScope.of((String)resourceId), securityContext);
        Authorization checkedAuthorization = Authorization.of(a -> a.resourceType(requiredAuthorization.resourceType()).permissionType(requiredAuthorization.permissionType()).resourceIds(List.of(resourceId)));
        return isAuthorized ? ResourceAccess.allowed((Authorization)checkedAuthorization) : ResourceAccess.denied((Authorization)checkedAuthorization);
    }

    private SecurityContext createSecurityContext(CamundaAuthentication authentication, Authorization<?> authorization) {
        return SecurityContext.of(s -> s.withAuthentication(authentication).withAuthorization(authorization));
    }
}

