/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.aggregator;

import io.camunda.search.clients.aggregator.SearchAggregator;
import io.camunda.util.ObjectBuilder;
import java.util.List;
import java.util.Objects;

public record SearchTopHitsAggregator<T>(String name, String field, Integer size, List<SearchAggregator> aggregations, Class<T> documentClass) implements SearchAggregator
{
    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<SearchAggregator> getAggregations() {
        return this.aggregations;
    }

    public static final class Builder<T>
    extends SearchAggregator.AbstractBuilder<Builder<T>>
    implements ObjectBuilder<SearchTopHitsAggregator<T>> {
        private String field;
        private Integer size = 1;
        private Class<T> documentClass;

        @Override
        protected Builder<T> self() {
            return this;
        }

        public Builder<T> field(String value) {
            this.field = value;
            return this;
        }

        public Builder<T> documentClass(Class<T> documentClass) {
            this.documentClass = documentClass;
            return this;
        }

        public Builder<T> size(Integer value) {
            if (value != null && value < 0) {
                throw new IllegalArgumentException("Size must be a positive integer.");
            }
            this.size = value;
            return this;
        }

        public SearchTopHitsAggregator<T> build() {
            return new SearchTopHitsAggregator<T>(Objects.requireNonNull(this.name, "Expected non-null field for name."), Objects.requireNonNull(this.field, "Expected non-null field for field."), this.size, this.aggregations, this.documentClass);
        }
    }
}

