/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.aggregator;

import io.camunda.search.clients.aggregator.SearchAggregator;
import io.camunda.search.sort.SortOption;
import io.camunda.util.ObjectBuilder;
import java.util.List;
import java.util.Objects;

public record SearchTermsAggregator(String name, String field, Integer size, Integer minDocCount, List<SortOption.FieldSorting> sorting, List<SearchAggregator> aggregations) implements SearchAggregator
{
    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<SearchAggregator> getAggregations() {
        return this.aggregations;
    }

    public static final class Builder
    extends SearchAggregator.AbstractBuilder<Builder>
    implements ObjectBuilder<SearchTermsAggregator> {
        private String field;
        private Integer size = 10;
        private Integer minDocCount = 1;
        private List<SortOption.FieldSorting> sorting;

        @Override
        protected Builder self() {
            return this;
        }

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder sorting(List<SortOption.FieldSorting> value) {
            if (value == null) {
                throw new IllegalArgumentException("Order must not be null.");
            }
            this.sorting = value;
            return this;
        }

        public Builder size(Integer value) {
            if (value != null && value < 0) {
                throw new IllegalArgumentException("Size must be a positive integer.");
            }
            this.size = value;
            return this;
        }

        public Builder minDocCount(Integer value) {
            this.minDocCount = value;
            return this;
        }

        public SearchTermsAggregator build() {
            return new SearchTermsAggregator(Objects.requireNonNull(this.name, "Expected non-null field for name."), Objects.requireNonNull(this.field, "Expected non-null field for field."), this.size, this.minDocCount, this.sorting, this.aggregations);
        }
    }
}

