/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients;

import io.camunda.search.clients.DocumentBasedSearchClient;
import io.camunda.search.clients.DocumentBasedWriteClient;
import io.camunda.search.clients.PersistentWebSessionClient;
import io.camunda.search.clients.core.SearchDeleteRequest;
import io.camunda.search.clients.core.SearchGetRequest;
import io.camunda.search.clients.core.SearchGetResponse;
import io.camunda.search.clients.core.SearchIndexRequest;
import io.camunda.search.clients.core.SearchQueryHit;
import io.camunda.search.clients.core.SearchQueryRequest;
import io.camunda.search.clients.core.SearchQueryResponse;
import io.camunda.search.entities.PersistentWebSessionEntity;
import io.camunda.search.query.SearchQueryResult;
import io.camunda.webapps.schema.descriptors.index.PersistentWebSessionIndexDescriptor;

public class PersistentWebSessionSearchImpl
implements PersistentWebSessionClient {
    private final DocumentBasedSearchClient readClient;
    private final DocumentBasedWriteClient writeClient;
    private final PersistentWebSessionIndexDescriptor persistentWebSessionIndex;

    public PersistentWebSessionSearchImpl(DocumentBasedSearchClient readClient, DocumentBasedWriteClient writeClient, PersistentWebSessionIndexDescriptor persistentWebSessionIndex) {
        this.readClient = readClient;
        this.writeClient = writeClient;
        this.persistentWebSessionIndex = persistentWebSessionIndex;
    }

    public PersistentWebSessionEntity getPersistentWebSession(String sessionId) {
        SearchGetRequest request = SearchGetRequest.of(b -> b.id(sessionId).index(this.persistentWebSessionIndex.getFullQualifiedName()));
        SearchGetResponse<PersistentWebSessionEntity> session = this.readClient.get(request, PersistentWebSessionEntity.class);
        return session.source();
    }

    public void upsertPersistentWebSession(PersistentWebSessionEntity persistentWebSessionEntity) {
        this.writeClient.index(SearchIndexRequest.of(b -> b.id(persistentWebSessionEntity.id()).index(this.persistentWebSessionIndex.getFullQualifiedName()).document(persistentWebSessionEntity)));
    }

    public void deletePersistentWebSession(String sessionId) {
        this.writeClient.delete(SearchDeleteRequest.of(b -> b.id(sessionId).index(this.persistentWebSessionIndex.getFullQualifiedName())));
    }

    public SearchQueryResult<PersistentWebSessionEntity> getAllPersistentWebSessions() {
        SearchQueryResponse<PersistentWebSessionEntity> response = this.readClient.scroll(SearchQueryRequest.of(b -> b.index(this.persistentWebSessionIndex.getFullQualifiedName(), new String[0])), PersistentWebSessionEntity.class);
        return SearchQueryResult.of(r -> r.items(response.hits().stream().map(SearchQueryHit::source).toList()));
    }
}

