/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.sort;

import io.camunda.search.clients.transformers.ServiceTransformer;
import io.camunda.search.clients.transformers.sort.FieldSortingTransformer;
import io.camunda.search.sort.SearchSortOptions;
import io.camunda.search.sort.SortOption;
import io.camunda.search.sort.SortOptionsBuilders;
import io.camunda.search.sort.SortOrder;
import io.camunda.zeebe.util.collection.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class SortingTransformer
implements ServiceTransformer<Tuple<List<SortOption.FieldSorting>, Boolean>, List<SearchSortOptions>> {
    private final FieldSortingTransformer fieldSortingTransformer;

    public SortingTransformer(FieldSortingTransformer fieldSortingTransformer) {
        this.fieldSortingTransformer = fieldSortingTransformer;
    }

    @Override
    public List<SearchSortOptions> apply(Tuple<List<SortOption.FieldSorting>, Boolean> value) {
        List orderings = (List)value.getLeft();
        Boolean reverse = (Boolean)value.getRight();
        List<SearchSortOptions> sorting = this.map(orderings, reverse);
        SearchSortOptions defaultSorting = this.getDefaultSearchSortOption(reverse);
        sorting.add(defaultSorting);
        return sorting;
    }

    private List<SearchSortOptions> map(List<SortOption.FieldSorting> orderings, boolean reverse) {
        List<Object> sorting = orderings != null && !orderings.isEmpty() ? orderings.stream().map(f -> this.toSearchSortOption((SortOption.FieldSorting)f, reverse)).collect(Collectors.toList()) : new ArrayList<SearchSortOptions>();
        return sorting;
    }

    private SearchSortOptions toSearchSortOption(SortOption.FieldSorting value, boolean reverse) {
        String field = this.fieldSortingTransformer.apply(value.field());
        SortOrder order = value.order();
        if (!reverse) {
            return SortOptionsBuilders.sortOptions((String)field, (SortOrder)order, (String)"_last");
        }
        return SortOptionsBuilders.sortOptions((String)field, (SortOrder)SortOptionsBuilders.reverseOrder((SortOrder)order), (String)"_first");
    }

    private SearchSortOptions getDefaultSearchSortOption(boolean reverse) {
        return SortOptionsBuilders.sortOptions((String)this.fieldSortingTransformer.defaultSortField(), (SortOrder)(reverse ? SortOrder.DESC : SortOrder.ASC));
    }
}

