/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.query;

import io.camunda.search.clients.core.SearchQueryHit;
import io.camunda.search.clients.core.SearchQueryResponse;
import io.camunda.search.clients.transformers.ServiceTransformer;
import io.camunda.search.clients.transformers.query.Cursor;
import io.camunda.search.query.SearchQueryResult;
import java.util.Collections;
import java.util.List;
import java.util.SequencedCollection;
import java.util.stream.Collectors;

public final class SearchQueryResultTransformer<T, R> {
    final ServiceTransformer<T, R> documentToEntityMapper;

    public SearchQueryResultTransformer(ServiceTransformer<T, R> documentToEntityMapper) {
        this.documentToEntityMapper = documentToEntityMapper;
    }

    public SearchQueryResult<R> apply(SearchQueryResponse<T> value, boolean reverse) {
        Object[] lastSortValues;
        Object[] firstSortValues;
        SequencedCollection<SearchQueryHit<Object>> hits = reverse ? value.hits().reversed() : value.hits();
        List<T> items = this.of((List<SearchQueryHit<T>>)hits);
        int size = hits.size();
        if (size > 0) {
            firstSortValues = ((SearchQueryHit)hits.getFirst()).sortValues();
            lastSortValues = ((SearchQueryHit)hits.getLast()).sortValues();
        } else {
            firstSortValues = null;
            lastSortValues = null;
        }
        return new SearchQueryResult.Builder().total(value.totalHits(), value.hasMoreTotalItems()).startCursor(Cursor.encode(firstSortValues)).endCursor(Cursor.encode(lastSortValues)).items(items.stream().map(this.documentToEntityMapper::apply).toList()).build();
    }

    private List<T> of(List<SearchQueryHit<T>> values) {
        if (values != null) {
            return values.stream().map(SearchQueryHit::source).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

