/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.transformers.ServiceTransformers;
import io.camunda.search.clients.transformers.filter.FilterTransformer;
import io.camunda.search.clients.transformers.filter.IndexFilterTransformer;
import io.camunda.search.filter.Operation;
import io.camunda.search.filter.UserTaskFilter;
import io.camunda.search.filter.VariableValueFilter;
import io.camunda.security.auth.Authorization;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import io.camunda.webapps.schema.entities.usertask.TaskEntity;
import io.camunda.webapps.schema.entities.usertask.TaskJoinRelationship;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class UserTaskFilterTransformer
extends IndexFilterTransformer<UserTaskFilter> {
    private final ServiceTransformers transformers;

    public UserTaskFilterTransformer(ServiceTransformers transformers, IndexDescriptor indexDescriptor) {
        super(indexDescriptor);
        this.transformers = transformers;
    }

    @Override
    public SearchQuery toSearchQuery(UserTaskFilter filter) {
        ArrayList<SearchQuery> queries = new ArrayList<SearchQuery>();
        Optional.ofNullable(this.getUserTaskKeysQuery(filter.userTaskKeys())).ifPresent(queries::add);
        Optional.ofNullable(this.getProcessInstanceKeysQuery(filter.processInstanceKeys())).ifPresent(queries::add);
        Optional.ofNullable(this.getProcessDefinitionKeyQuery(filter.processDefinitionKeys())).ifPresent(queries::add);
        Optional.ofNullable(this.getBpmnProcessIdQuery(filter.bpmnProcessIds())).ifPresent(queries::add);
        Optional.ofNullable(this.getElementIdQuery(filter.elementIds())).ifPresent(queries::add);
        Optional.ofNullable(this.getNameQuery(filter.names())).ifPresent(queries::add);
        queries.addAll(this.getCandidateUsersQuery(filter.candidateUserOperations()));
        queries.addAll(this.getCandidateGroupsQuery(filter.candidateGroupOperations()));
        queries.addAll(this.getAssigneesQuery(filter.assigneeOperations()));
        queries.addAll(this.getPrioritiesQuery(filter.priorityOperations()));
        queries.addAll(this.getStatesQuery(filter.stateOperations()));
        Optional.ofNullable(this.getTenantQuery(filter.tenantIds())).ifPresent(queries::add);
        Optional.ofNullable(this.getElementInstanceKeyQuery(filter.elementInstanceKeys())).ifPresent(queries::add);
        queries.addAll(this.getCreationTimeQuery(filter.creationDateOperations()));
        queries.addAll(this.getCompletionTimeQuery(filter.completionDateOperations()));
        queries.addAll(this.getFollowUpDateQuery(filter.followUpDateOperations()));
        queries.addAll(this.getDueDateQuery(filter.dueDateOperations()));
        Optional.ofNullable(this.getProcessInstanceVariablesQuery(filter.processInstanceVariableFilter())).ifPresent(f -> queries.add(SearchQueryBuilders.hasParentQuery(TaskJoinRelationship.TaskJoinRelationshipType.PROCESS.getType(), f)));
        Optional.ofNullable(this.getLocalVariablesQuery(filter.localVariableFilters())).ifPresent(queries::add);
        queries.add(SearchQueryBuilders.exists("flowNodeInstanceId"));
        queries.add(SearchQueryBuilders.stringTerms("implementation", List.of(TaskEntity.TaskImplementation.ZEEBE_USER_TASK.name())));
        return SearchQueryBuilders.and(queries);
    }

    @Override
    protected SearchQuery toAuthorizationCheckSearchQuery(Authorization<?> authorization) {
        return SearchQueryBuilders.stringTerms("bpmnProcessId", authorization.resourceIds());
    }

    private SearchQuery getProcessInstanceKeysQuery(List<Long> processInstanceKeys) {
        return SearchQueryBuilders.longTerms("processInstanceId", processInstanceKeys);
    }

    private SearchQuery getProcessDefinitionKeyQuery(List<Long> processDefinitionIds) {
        return SearchQueryBuilders.longTerms("processDefinitionId", processDefinitionIds);
    }

    private SearchQuery getUserTaskKeysQuery(List<Long> userTaskKeys) {
        return SearchQueryBuilders.longTerms("key", userTaskKeys);
    }

    private List<SearchQuery> getCandidateUsersQuery(List<Operation<String>> candidateUsers) {
        return SearchQueryBuilders.stringOperations("candidateUsers", candidateUsers);
    }

    private List<SearchQuery> getCandidateGroupsQuery(List<Operation<String>> candidateGroups) {
        return SearchQueryBuilders.stringOperations("candidateGroups", candidateGroups);
    }

    private List<SearchQuery> getAssigneesQuery(List<Operation<String>> assignees) {
        return SearchQueryBuilders.stringOperations("assignee", assignees);
    }

    private List<SearchQuery> getPrioritiesQuery(List<Operation<Integer>> priorities) {
        return SearchQueryBuilders.intOperations("priority", priorities);
    }

    private List<SearchQuery> getCreationTimeQuery(List<Operation<OffsetDateTime>> creationTime) {
        return SearchQueryBuilders.dateTimeOperations("creationTime", creationTime);
    }

    private List<SearchQuery> getCompletionTimeQuery(List<Operation<OffsetDateTime>> completionTime) {
        return SearchQueryBuilders.dateTimeOperations("completionTime", completionTime);
    }

    private List<SearchQuery> getFollowUpDateQuery(List<Operation<OffsetDateTime>> followUpTime) {
        return SearchQueryBuilders.dateTimeOperations("followUpDate", followUpTime);
    }

    private List<SearchQuery> getDueDateQuery(List<Operation<OffsetDateTime>> dueTime) {
        return SearchQueryBuilders.dateTimeOperations("dueDate", dueTime);
    }

    private List<SearchQuery> getStatesQuery(List<Operation<String>> states) {
        return SearchQueryBuilders.stringOperations("state", states);
    }

    private SearchQuery getTenantQuery(List<String> tenant) {
        return SearchQueryBuilders.stringTerms("tenantId", tenant);
    }

    private SearchQuery getBpmnProcessIdQuery(List<String> bpmnProcessId) {
        return SearchQueryBuilders.stringTerms("bpmnProcessId", bpmnProcessId);
    }

    private SearchQuery getElementInstanceKeyQuery(List<Long> elementInstanceKeys) {
        return SearchQueryBuilders.longTerms("flowNodeInstanceId", elementInstanceKeys);
    }

    private SearchQuery getElementIdQuery(List<String> taskDefinitionId) {
        return SearchQueryBuilders.stringTerms("flowNodeBpmnId", taskDefinitionId);
    }

    private SearchQuery getNameQuery(List<String> name) {
        return SearchQueryBuilders.stringTerms("name", name);
    }

    private SearchQuery getProcessInstanceVariablesQuery(List<VariableValueFilter> variableFilters) {
        if (variableFilters != null && !variableFilters.isEmpty()) {
            FilterTransformer<VariableValueFilter> transformer = this.getVariableValueFilterTransformer();
            List<SearchQuery> queries = variableFilters.stream().map(transformer::apply).map(q -> SearchQueryBuilders.hasChildQuery(TaskJoinRelationship.TaskJoinRelationshipType.PROCESS_VARIABLE.getType(), q)).collect(Collectors.toList());
            return SearchQueryBuilders.and(queries);
        }
        return null;
    }

    private SearchQuery getLocalVariablesQuery(List<VariableValueFilter> variableFilters) {
        if (variableFilters != null && !variableFilters.isEmpty()) {
            FilterTransformer<VariableValueFilter> transformer = this.getVariableValueFilterTransformer();
            List<SearchQuery> queries = variableFilters.stream().map(transformer::apply).map(q -> SearchQueryBuilders.hasChildQuery(TaskJoinRelationship.TaskJoinRelationshipType.LOCAL_VARIABLE.getType(), q)).collect(Collectors.toList());
            return SearchQueryBuilders.and(queries);
        }
        return null;
    }

    private FilterTransformer<VariableValueFilter> getVariableValueFilterTransformer() {
        return this.transformers.getFilterTransformer(VariableValueFilter.class);
    }
}

