/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.transformers.filter.IndexFilterTransformer;
import io.camunda.search.filter.Operation;
import io.camunda.search.filter.UsageMetricsFilter;
import io.camunda.security.auth.Authorization;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import io.camunda.webapps.schema.descriptors.index.MetricIndex;
import io.camunda.webapps.schema.descriptors.index.TasklistMetricIndex;
import java.util.ArrayList;
import java.util.List;

public class UsageMetricsFilterTransformer
extends IndexFilterTransformer<UsageMetricsFilter> {
    private final TasklistMetricIndex tasklistMetricIndex;
    private final MetricIndex operateMetricIndex;
    private UsageMetricsFilter filter;

    public UsageMetricsFilterTransformer(TasklistMetricIndex tasklistMetricIndex, MetricIndex metricIndex) {
        super((IndexDescriptor)metricIndex);
        this.tasklistMetricIndex = tasklistMetricIndex;
        this.operateMetricIndex = metricIndex;
    }

    @Override
    public SearchQuery toSearchQuery(UsageMetricsFilter filter) {
        this.filter = filter;
        ArrayList<SearchQuery> queries = new ArrayList<SearchQuery>();
        queries.add(SearchQueryBuilders.stringTerms("event", filter.events()));
        queries.addAll(SearchQueryBuilders.dateTimeOperations("eventTime", List.of(Operation.gte((Object)filter.startTime()), Operation.lte((Object)filter.endTime()))));
        return SearchQueryBuilders.and(queries);
    }

    @Override
    protected SearchQuery toAuthorizationCheckSearchQuery(Authorization<?> authorization) {
        return SearchQueryBuilders.matchAll();
    }

    @Override
    public IndexDescriptor getIndex() {
        if (this.shouldUseTasklistIndex(this.filter)) {
            return this.tasklistMetricIndex;
        }
        return this.operateMetricIndex;
    }

    private boolean shouldUseTasklistIndex(UsageMetricsFilter filter) {
        return filter != null && filter.events().contains("task_completed_by_assignee");
    }
}

