/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.transformers.filter.IndexFilterTransformer;
import io.camunda.search.filter.RoleFilter;
import io.camunda.security.auth.Authorization;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import io.camunda.webapps.schema.entities.usermanagement.EntityJoinRelation;
import io.camunda.zeebe.protocol.record.value.EntityType;
import java.util.Collection;

public class RoleFilterTransformer
extends IndexFilterTransformer<RoleFilter> {
    public RoleFilterTransformer(IndexDescriptor indexDescriptor) {
        super(indexDescriptor);
    }

    @Override
    public SearchQuery toSearchQuery(RoleFilter filter) {
        if (filter.memberIdsByType() != null && !filter.memberIdsByType().isEmpty()) {
            return this.createMultipleMemberTypeQuery(filter);
        }
        SearchQuery[] searchQueryArray = new SearchQuery[7];
        searchQueryArray[0] = filter.name() == null ? null : SearchQueryBuilders.term("name", filter.name());
        searchQueryArray[1] = filter.description() == null ? null : SearchQueryBuilders.term("description", filter.description());
        searchQueryArray[2] = filter.memberType() == null ? null : SearchQueryBuilders.term("memberType", filter.memberType().name());
        SearchQuery searchQuery = searchQueryArray[3] = filter.joinParentId() == null ? SearchQueryBuilders.term("join", EntityJoinRelation.IdentityJoinRelationshipType.ROLE.getType()) : SearchQueryBuilders.hasParentQuery(EntityJoinRelation.IdentityJoinRelationshipType.ROLE.getType(), SearchQueryBuilders.term("roleId", filter.joinParentId()));
        searchQueryArray[4] = filter.memberIds() == null ? null : (filter.memberIds().isEmpty() ? SearchQueryBuilders.matchNone() : SearchQueryBuilders.hasChildQuery(EntityJoinRelation.IdentityJoinRelationshipType.MEMBER.getType(), SearchQueryBuilders.stringTerms("memberId", filter.memberIds())));
        SearchQuery searchQuery2 = searchQueryArray[5] = filter.childMemberType() == null ? null : SearchQueryBuilders.hasChildQuery(EntityJoinRelation.IdentityJoinRelationshipType.MEMBER.getType(), SearchQueryBuilders.term("memberType", filter.childMemberType().name()));
        searchQueryArray[6] = filter.roleIds() == null ? null : (filter.roleIds().isEmpty() ? SearchQueryBuilders.matchNone() : SearchQueryBuilders.stringTerms("roleId", filter.roleIds()));
        return SearchQueryBuilders.and(filter.roleId() == null ? null : SearchQueryBuilders.term("roleId", filter.roleId()), searchQueryArray);
    }

    @Override
    protected SearchQuery toAuthorizationCheckSearchQuery(Authorization<?> authorization) {
        return SearchQueryBuilders.stringTerms("roleId", authorization.resourceIds());
    }

    private SearchQuery createMultipleMemberTypeQuery(RoleFilter filter) {
        return SearchQueryBuilders.or(filter.memberIdsByType().entrySet().stream().map(entry -> SearchQueryBuilders.hasChildQuery(EntityJoinRelation.IdentityJoinRelationshipType.MEMBER.getType(), SearchQueryBuilders.and(SearchQueryBuilders.term("memberType", ((EntityType)entry.getKey()).name()), SearchQueryBuilders.stringTerms("memberId", (Collection)entry.getValue())))).toList());
    }
}

