/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.transformers.ServiceTransformers;
import io.camunda.search.clients.transformers.filter.FilterTransformer;
import io.camunda.search.clients.transformers.filter.IndexFilterTransformer;
import io.camunda.search.clients.transformers.filter.VariableValueFilterTransformer;
import io.camunda.search.filter.ProcessInstanceFilter;
import io.camunda.search.filter.VariableValueFilter;
import io.camunda.security.auth.Authorization;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ProcessInstanceFilterTransformer
extends IndexFilterTransformer<ProcessInstanceFilter> {
    private final ServiceTransformers transformers;

    public ProcessInstanceFilterTransformer(ServiceTransformers transformers, IndexDescriptor indexDescriptor) {
        super(indexDescriptor);
        this.transformers = transformers;
    }

    public ArrayList<SearchQuery> toSearchQueryFields(ProcessInstanceFilter filter) {
        ArrayList<SearchQuery> queries = new ArrayList<SearchQuery>();
        queries.addAll(SearchQueryBuilders.longOperations("key", filter.processInstanceKeyOperations()));
        queries.addAll(SearchQueryBuilders.stringOperations("bpmnProcessId", filter.processDefinitionIdOperations()));
        queries.addAll(SearchQueryBuilders.stringOperations("processName", filter.processDefinitionNameOperations()));
        queries.addAll(SearchQueryBuilders.intOperations("processVersion", filter.processDefinitionVersionOperations()));
        queries.addAll(SearchQueryBuilders.stringOperations("processVersionTag", filter.processDefinitionVersionTagOperations()));
        queries.addAll(SearchQueryBuilders.longOperations("processDefinitionKey", filter.processDefinitionKeyOperations()));
        queries.addAll(SearchQueryBuilders.longOperations("parentProcessInstanceKey", filter.parentProcessInstanceKeyOperations()));
        queries.addAll(SearchQueryBuilders.longOperations("parentFlowNodeInstanceKey", filter.parentFlowNodeInstanceKeyOperations()));
        queries.addAll(SearchQueryBuilders.dateTimeOperations("startDate", filter.startDateOperations()));
        queries.addAll(SearchQueryBuilders.dateTimeOperations("endDate", filter.endDateOperations()));
        queries.addAll(SearchQueryBuilders.stringOperations("state", filter.stateOperations()));
        Optional.ofNullable(this.getIncidentQuery(filter.hasIncident())).ifPresent(queries::add);
        queries.addAll(SearchQueryBuilders.stringOperations("tenantId", filter.tenantIdOperations()));
        if (filter.variableFilters() != null && !filter.variableFilters().isEmpty()) {
            SearchQuery processVariableQuery = this.getProcessVariablesQuery(filter.variableFilters());
            queries.add(processVariableQuery);
        }
        if (filter.errorMessageOperations() != null && !filter.errorMessageOperations().isEmpty()) {
            queries.addAll(SearchQueryBuilders.stringMatchPhraseWithHasChildOperations("errorMessage", filter.errorMessageOperations(), "activity"));
        }
        queries.addAll(SearchQueryBuilders.stringOperations("batchOperationIds", filter.batchOperationIdOperations()));
        Optional.ofNullable(this.getHasRetriesLeftQuery(filter.hasRetriesLeft())).ifPresent(queries::add);
        if (filter.flowNodeIdOperations() != null && !filter.flowNodeIdOperations().isEmpty()) {
            queries.add(ProcessInstanceFilterTransformer.getFlowNodeInstanceQuery(filter));
        }
        if (filter.partitionId() != null) {
            queries.add(SearchQueryBuilders.term("partitionId", filter.partitionId()));
        }
        return queries;
    }

    @Override
    public SearchQuery toSearchQuery(ProcessInstanceFilter filter) {
        ArrayList<SearchQuery> queries = new ArrayList<SearchQuery>();
        Optional.ofNullable(this.getIsProcessInstanceQuery()).ifPresent(queries::add);
        queries.addAll(this.toSearchQueryFields(filter));
        if (filter.orFilters() != null && !filter.orFilters().isEmpty()) {
            ArrayList<SearchQuery> orQueries = new ArrayList<SearchQuery>();
            filter.orFilters().stream().map(f -> SearchQueryBuilders.and(this.toSearchQueryFields((ProcessInstanceFilter)f))).forEach(orQueries::add);
            queries.add(SearchQueryBuilders.or(orQueries));
        }
        return SearchQueryBuilders.and(queries);
    }

    @Override
    protected SearchQuery toAuthorizationCheckSearchQuery(Authorization<?> authorization) {
        return SearchQueryBuilders.stringTerms("bpmnProcessId", authorization.resourceIds());
    }

    private static SearchQuery getFlowNodeInstanceQuery(ProcessInstanceFilter filter) {
        ArrayList<SearchQuery> flowNodeInstanceQueries = new ArrayList<SearchQuery>();
        Optional.of(SearchQueryBuilders.stringOperations("activityId", filter.flowNodeIdOperations())).ifPresent(flowNodeInstanceQueries::addAll);
        Optional.of(SearchQueryBuilders.stringOperations("activityState", filter.flowNodeInstanceStateOperations())).ifPresent(flowNodeInstanceQueries::addAll);
        Optional.ofNullable(filter.hasFlowNodeInstanceIncident()).ifPresent(incident -> flowNodeInstanceQueries.add(SearchQueryBuilders.term("incident", incident)));
        return SearchQueryBuilders.hasChildQuery("activity", SearchQueryBuilders.and(flowNodeInstanceQueries));
    }

    private SearchQuery getHasRetriesLeftQuery(Boolean hasRetriesLeft) {
        if (hasRetriesLeft != null) {
            return SearchQueryBuilders.hasChildQuery("activity", SearchQueryBuilders.term("jobFailedWithRetriesLeft", hasRetriesLeft));
        }
        return null;
    }

    private SearchQuery getIsProcessInstanceQuery() {
        return SearchQueryBuilders.term("joinRelation", "processInstance");
    }

    private SearchQuery getIncidentQuery(Boolean hasIncident) {
        if (hasIncident != null) {
            return SearchQueryBuilders.term("incident", hasIncident);
        }
        return null;
    }

    private SearchQuery getProcessVariablesQuery(List<VariableValueFilter> variableFilters) {
        if (variableFilters != null && !variableFilters.isEmpty()) {
            FilterTransformer<VariableValueFilter> transformer = this.getVariableValueFilterTransformer();
            VariableValueFilterTransformer variableTransformer = (VariableValueFilterTransformer)transformer;
            List<SearchQuery> queries = variableFilters.stream().map(v -> variableTransformer.toSearchQuery((VariableValueFilter)v, "varName", "varValue")).map(q -> SearchQueryBuilders.hasChildQuery("variable", q)).collect(Collectors.toList());
            return SearchQueryBuilders.and(queries);
        }
        return null;
    }

    private FilterTransformer<VariableValueFilter> getVariableValueFilterTransformer() {
        return this.transformers.getFilterTransformer(VariableValueFilter.class);
    }
}

