/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.transformers.ServiceTransformers;
import io.camunda.search.clients.transformers.filter.FilterTransformer;
import io.camunda.search.clients.transformers.filter.IndexFilterTransformer;
import io.camunda.search.clients.transformers.filter.VariableValueFilterTransformer;
import io.camunda.search.filter.ProcessDefinitionStatisticsFilter;
import io.camunda.search.filter.VariableValueFilter;
import io.camunda.security.auth.Authorization;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ProcessDefinitionStatisticsFilterTransformer
extends IndexFilterTransformer<ProcessDefinitionStatisticsFilter> {
    private final ServiceTransformers transformers;

    public ProcessDefinitionStatisticsFilterTransformer(ServiceTransformers transformers, IndexDescriptor indexDescriptor) {
        super(indexDescriptor);
        this.transformers = transformers;
    }

    @Override
    public SearchQuery toSearchQuery(ProcessDefinitionStatisticsFilter filter) {
        ArrayList<SearchQuery> queries = new ArrayList<SearchQuery>();
        queries.add(SearchQueryBuilders.term("joinRelation", "activity"));
        queries.add(SearchQueryBuilders.hasParentQuery("processInstance", SearchQueryBuilders.term("processDefinitionKey", filter.processDefinitionKey())));
        queries.addAll(this.toSearchQueryFields(filter));
        if (filter.orFilters() != null && !filter.orFilters().isEmpty()) {
            ArrayList<SearchQuery> orQueries = new ArrayList<SearchQuery>();
            filter.orFilters().stream().map(f -> SearchQueryBuilders.and(this.toSearchQueryFields((ProcessDefinitionStatisticsFilter)f))).forEach(orQueries::add);
            queries.add(SearchQueryBuilders.or(orQueries));
        }
        return SearchQueryBuilders.and(queries);
    }

    public ArrayList<SearchQuery> toSearchQueryFields(ProcessDefinitionStatisticsFilter filter) {
        ArrayList<SearchQuery> queries = new ArrayList<SearchQuery>();
        this.toProcessInstanceQueries(filter).ifPresent(query -> queries.add(SearchQueryBuilders.hasParentQuery("processInstance", SearchQueryBuilders.and((List<SearchQuery>)query))));
        this.toFlowNodeInstanceQueries(filter).ifPresent(queries::addAll);
        return queries;
    }

    private Optional<ArrayList<SearchQuery>> toFlowNodeInstanceQueries(ProcessDefinitionStatisticsFilter filter) {
        ArrayList queries = new ArrayList();
        Optional.of(SearchQueryBuilders.stringOperations("activityId", filter.flowNodeIdOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.stringOperations("activityState", filter.flowNodeInstanceStateOperations())).ifPresent(queries::addAll);
        Optional.ofNullable(filter.hasFlowNodeInstanceIncident()).ifPresent(value -> queries.add(SearchQueryBuilders.term("incident", value)));
        return Optional.ofNullable(queries.isEmpty() ? null : queries);
    }

    private Optional<ArrayList<SearchQuery>> toProcessInstanceQueries(ProcessDefinitionStatisticsFilter filter) {
        ArrayList<SearchQuery> queries = new ArrayList<SearchQuery>();
        Optional.of(SearchQueryBuilders.longOperations("key", filter.processInstanceKeyOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.longOperations("parentProcessInstanceKey", filter.parentProcessInstanceKeyOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.longOperations("parentFlowNodeInstanceKey", filter.parentFlowNodeInstanceKeyOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.dateTimeOperations("startDate", filter.startDateOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.dateTimeOperations("endDate", filter.endDateOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.stringOperations("state", filter.stateOperations())).ifPresent(queries::addAll);
        Optional.ofNullable(filter.hasIncident()).ifPresent(value -> queries.add(SearchQueryBuilders.term("incident", value)));
        Optional.of(SearchQueryBuilders.stringOperations("tenantId", filter.tenantIdOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.stringMatchPhraseWithHasChildOperations("errorMessage", filter.errorMessageOperations(), "activity")).ifPresent(queries::addAll);
        Optional.ofNullable(this.getProcessVariablesQuery(filter.variableFilters())).ifPresent(queries::add);
        queries.addAll(SearchQueryBuilders.stringOperations("batchOperationIds", filter.batchOperationIdOperations()));
        Optional.ofNullable(filter.hasRetriesLeft()).ifPresent(value -> queries.add(ProcessDefinitionStatisticsFilterTransformer.hasRetriesLeftQuery(value)));
        return Optional.ofNullable(queries.isEmpty() ? null : queries);
    }

    @Override
    protected SearchQuery toAuthorizationCheckSearchQuery(Authorization<?> authorization) {
        return SearchQueryBuilders.stringTerms("bpmnProcessId", authorization.resourceIds());
    }

    private static SearchQuery hasRetriesLeftQuery(Boolean value) {
        return SearchQueryBuilders.hasChildQuery("activity", SearchQueryBuilders.term("jobFailedWithRetriesLeft", value));
    }

    private SearchQuery getProcessVariablesQuery(List<VariableValueFilter> variableFilters) {
        if (variableFilters != null && !variableFilters.isEmpty()) {
            FilterTransformer<VariableValueFilter> transformer = this.getVariableValueFilterTransformer();
            VariableValueFilterTransformer variableTransformer = (VariableValueFilterTransformer)transformer;
            List<SearchQuery> queries = variableFilters.stream().map(v -> variableTransformer.toSearchQuery((VariableValueFilter)v, "varName", "varValue")).map(q -> SearchQueryBuilders.hasChildQuery("variable", q)).collect(Collectors.toList());
            return SearchQueryBuilders.and(queries);
        }
        return null;
    }

    private FilterTransformer<VariableValueFilter> getVariableValueFilterTransformer() {
        return this.transformers.getFilterTransformer(VariableValueFilter.class);
    }
}

