/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.transformers.filter.IndexFilterTransformer;
import io.camunda.search.filter.MessageSubscriptionFilter;
import io.camunda.security.auth.Authorization;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import java.util.List;

public class MessageSubscriptionFilterTransformer
extends IndexFilterTransformer<MessageSubscriptionFilter> {
    public MessageSubscriptionFilterTransformer(IndexDescriptor indexDescriptor) {
        super(indexDescriptor);
    }

    @Override
    public SearchQuery toSearchQuery(MessageSubscriptionFilter filter) {
        SearchQuery messageSubscriptionTerm = SearchQueryBuilders.stringTerms("eventSourceType", List.of("PROCESS_MESSAGE_SUBSCRIPTION"));
        return SearchQueryBuilders.and(List.of(messageSubscriptionTerm), SearchQueryBuilders.longOperations("key", filter.messageSubscriptionKeyOperations()), SearchQueryBuilders.stringOperations("bpmnProcessId", filter.processDefinitionIdOperations()), SearchQueryBuilders.longOperations("processDefinitionKey", filter.processDefinitionKeyOperations()), SearchQueryBuilders.longOperations("processInstanceKey", filter.processInstanceKeyOperations()), SearchQueryBuilders.stringOperations("flowNodeId", filter.flowNodeIdOperations()), SearchQueryBuilders.longOperations("flowNodeInstanceKey", filter.flowNodeInstanceKeyOperations()), SearchQueryBuilders.stringOperations("eventType", filter.messageSubscriptionTypeOperations()), SearchQueryBuilders.dateTimeOperations("dateTime", filter.dateTimeOperations()), SearchQueryBuilders.stringOperations("metadata.messageName", filter.messageNameOperations()), SearchQueryBuilders.stringOperations("metadata.correlationKey", filter.correlationKeyOperations()), SearchQueryBuilders.stringOperations("tenantId", filter.tenantIdOperations()));
    }

    @Override
    protected SearchQuery toAuthorizationCheckSearchQuery(Authorization<?> authorization) {
        return SearchQueryBuilders.stringTerms("bpmnProcessId", authorization.resourceIds());
    }
}

