/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.transformers.filter.IndexFilterTransformer;
import io.camunda.search.filter.JobFilter;
import io.camunda.security.auth.Authorization;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import java.util.ArrayList;
import java.util.Optional;

public class JobFilterTransformer
extends IndexFilterTransformer<JobFilter> {
    public JobFilterTransformer(IndexDescriptor indexDescriptor) {
        super(indexDescriptor);
    }

    @Override
    public SearchQuery toSearchQuery(JobFilter filter) {
        ArrayList<SearchQuery> queries = new ArrayList<SearchQuery>();
        Optional.of(SearchQueryBuilders.dateTimeOperations("deadline", filter.deadlineOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.stringOperations("deniedReason", filter.deniedReasonOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.stringOperations("flowNodeId", filter.elementIdOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.longOperations("flowNodeInstanceId", filter.elementInstanceKeyOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.dateTimeOperations("endTime", filter.endTimeOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.stringOperations("errorCode", filter.errorCodeOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.stringOperations("errorMessage", filter.errorMessageOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.longOperations("key", filter.jobKeyOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.stringOperations("jobKind", filter.kindOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.stringOperations("listenerEventType", filter.listenerEventTypeOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.stringOperations("bpmnProcessId", filter.processDefinitionIdOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.longOperations("processDefinitionKey", filter.processDefinitionKeyOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.longOperations("processInstanceKey", filter.processInstanceKeyOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.intOperations("retries", filter.retriesOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.stringOperations("state", filter.stateOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.stringOperations("tenantId", filter.tenantIdOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.stringOperations("type", filter.typeOperations())).ifPresent(queries::addAll);
        Optional.of(SearchQueryBuilders.stringOperations("worker", filter.workerOperations())).ifPresent(queries::addAll);
        Optional.ofNullable(filter.hasFailedWithRetriesLeft()).ifPresent(f -> queries.add(SearchQueryBuilders.term("jobFailedWithRetriesLeft", f)));
        Optional.ofNullable(filter.isDenied()).ifPresent(f -> queries.add(SearchQueryBuilders.term("denied", f)));
        return SearchQueryBuilders.and(queries);
    }

    @Override
    protected SearchQuery toAuthorizationCheckSearchQuery(Authorization<?> authorization) {
        return SearchQueryBuilders.stringTerms("bpmnProcessId", authorization.resourceIds());
    }
}

