/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.transformers.filter.IndexFilterTransformer;
import io.camunda.search.filter.GroupFilter;
import io.camunda.security.auth.Authorization;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import io.camunda.webapps.schema.entities.usermanagement.EntityJoinRelation;
import io.camunda.zeebe.protocol.record.value.EntityType;
import java.util.ArrayList;
import java.util.Collection;

public class GroupFilterTransformer
extends IndexFilterTransformer<GroupFilter> {
    public GroupFilterTransformer(IndexDescriptor indexDescriptor) {
        super(indexDescriptor);
    }

    @Override
    public SearchQuery toSearchQuery(GroupFilter filter) {
        if (filter.memberIdsByType() != null && !filter.memberIdsByType().isEmpty()) {
            return this.createMultipleMemberTypeQuery(filter);
        }
        ArrayList<SearchQuery> queries = new ArrayList<SearchQuery>();
        if (filter.groupKey() != null) {
            queries.add(SearchQueryBuilders.term("key", filter.groupKey()));
        }
        if (filter.groupIdOperations() != null && !filter.groupIdOperations().isEmpty()) {
            queries.addAll(SearchQueryBuilders.stringOperations("groupId", filter.groupIdOperations()));
        }
        if (filter.name() != null) {
            queries.add(SearchQueryBuilders.term("name", filter.name()));
        }
        if (filter.description() != null) {
            queries.add(SearchQueryBuilders.term("description", filter.description()));
        }
        if (filter.memberIds() != null) {
            queries.add(filter.memberIds().isEmpty() ? SearchQueryBuilders.matchNone() : SearchQueryBuilders.hasChildQuery(EntityJoinRelation.IdentityJoinRelationshipType.MEMBER.getType(), SearchQueryBuilders.stringTerms("memberId", filter.memberIds())));
        }
        if (filter.memberType() != null) {
            queries.add(SearchQueryBuilders.term("memberType", filter.memberType().name()));
        }
        queries.add(filter.joinParentId() == null ? SearchQueryBuilders.term("join", EntityJoinRelation.IdentityJoinRelationshipType.GROUP.getType()) : SearchQueryBuilders.hasParentQuery(EntityJoinRelation.IdentityJoinRelationshipType.GROUP.getType(), SearchQueryBuilders.term("groupId", filter.joinParentId())));
        if (filter.childMemberType() != null) {
            queries.add(SearchQueryBuilders.hasChildQuery(EntityJoinRelation.IdentityJoinRelationshipType.MEMBER.getType(), SearchQueryBuilders.term("memberType", filter.childMemberType().name())));
        }
        return SearchQueryBuilders.and(queries);
    }

    private SearchQuery createMultipleMemberTypeQuery(GroupFilter filter) {
        return SearchQueryBuilders.or(filter.memberIdsByType().entrySet().stream().map(entry -> SearchQueryBuilders.hasChildQuery(EntityJoinRelation.IdentityJoinRelationshipType.MEMBER.getType(), SearchQueryBuilders.and(SearchQueryBuilders.term("memberType", ((EntityType)entry.getKey()).name()), SearchQueryBuilders.stringTerms("memberId", (Collection)entry.getValue())))).toList());
    }

    @Override
    protected SearchQuery toAuthorizationCheckSearchQuery(Authorization<?> authorization) {
        return SearchQueryBuilders.stringTerms("groupId", authorization.resourceIds());
    }
}

