/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.transformers.filter.IndexFilterTransformer;
import io.camunda.search.filter.AuthorizationFilter;
import io.camunda.security.auth.Authorization;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import io.camunda.zeebe.protocol.record.value.EntityType;
import java.util.Collection;

public final class AuthorizationFilterTransformer
extends IndexFilterTransformer<AuthorizationFilter> {
    public AuthorizationFilterTransformer(IndexDescriptor indexDescriptor) {
        super(indexDescriptor);
    }

    @Override
    public SearchQuery toSearchQuery(AuthorizationFilter filter) {
        if (filter.ownerTypeToOwnerIds() != null && !filter.ownerTypeToOwnerIds().isEmpty()) {
            return this.buildOwnerTypeToOwnerIdsQuery(filter);
        }
        return SearchQueryBuilders.and(this.buildCoreFilters(filter), SearchQueryBuilders.stringTerms("ownerId", filter.ownerIds()), filter.ownerType() == null ? null : SearchQueryBuilders.term("ownerType", filter.ownerType()));
    }

    @Override
    protected SearchQuery toAuthorizationCheckSearchQuery(Authorization<?> authorization) {
        return SearchQueryBuilders.longTerms("id", authorization.resourceIds().stream().map(Long::valueOf).toList());
    }

    private SearchQuery buildOwnerTypeToOwnerIdsQuery(AuthorizationFilter filter) {
        return SearchQueryBuilders.or(filter.ownerTypeToOwnerIds().entrySet().stream().map(entry -> SearchQueryBuilders.and(this.buildCoreFilters(filter), SearchQueryBuilders.term("ownerType", ((EntityType)entry.getKey()).name()), SearchQueryBuilders.stringTerms("ownerId", (Collection)entry.getValue()))).toList());
    }

    private SearchQuery buildCoreFilters(AuthorizationFilter filter) {
        return SearchQueryBuilders.and(filter.authorizationKey() == null ? null : SearchQueryBuilders.term("id", filter.authorizationKey()), SearchQueryBuilders.stringTerms("resourceId", filter.resourceIds()), filter.resourceType() == null ? null : SearchQueryBuilders.term("resourceType", filter.resourceType()), filter.permissionTypes() == null ? null : SearchQueryBuilders.stringTerms("permissionTypes", filter.permissionTypes().stream().map(Enum::name).toList()));
    }
}

