/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.transformers.entity;

import io.camunda.search.clients.transformers.ServiceTransformer;
import io.camunda.search.entities.BatchOperationEntity;
import io.camunda.webapps.schema.entities.operation.OperationEntity;
import io.camunda.webapps.schema.entities.operation.OperationState;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class BatchOperationItemEntityTransformer
implements ServiceTransformer<OperationEntity, BatchOperationEntity.BatchOperationItemEntity> {
    @Override
    public BatchOperationEntity.BatchOperationItemEntity apply(OperationEntity source) {
        if (source == null) {
            return null;
        }
        return BatchOperationItemEntityTransformer.isLegacy(source) ? this.mapLegacyBatchOperation(source) : this.mapBatchOperation(source);
    }

    private static boolean isLegacy(OperationEntity source) {
        return !StringUtils.isNumeric((CharSequence)source.getBatchOperationId());
    }

    private BatchOperationEntity.BatchOperationItemEntity mapBatchOperation(OperationEntity source) {
        return new BatchOperationEntity.BatchOperationItemEntity(source.getBatchOperationId(), source.getItemKey(), source.getProcessInstanceKey(), this.map(source.getState()), source.getCompletedDate(), source.getErrorMessage());
    }

    private BatchOperationEntity.BatchOperationItemEntity mapLegacyBatchOperation(OperationEntity source) {
        return new BatchOperationEntity.BatchOperationItemEntity(source.getBatchOperationId(), (Long)ObjectUtils.firstNonNull((Object[])new Long[]{source.getIncidentKey(), source.getProcessInstanceKey()}), source.getProcessInstanceKey(), this.map(source.getState()), source.getCompletedDate(), source.getErrorMessage());
    }

    private BatchOperationEntity.BatchOperationItemState map(OperationState state) {
        if (state == null) {
            return null;
        }
        return switch (state) {
            default -> throw new MatchException(null, null);
            case OperationState.SCHEDULED, OperationState.LOCKED, OperationState.SENT -> BatchOperationEntity.BatchOperationItemState.ACTIVE;
            case OperationState.COMPLETED -> BatchOperationEntity.BatchOperationItemState.COMPLETED;
            case OperationState.FAILED -> BatchOperationEntity.BatchOperationItemState.FAILED;
        };
    }
}

