/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.reader;

import io.camunda.search.clients.SearchClientBasedQueryExecutor;
import io.camunda.search.clients.reader.DocumentBasedReader;
import io.camunda.search.clients.reader.GroupMemberDocumentReader;
import io.camunda.search.clients.reader.RoleMemberDocumentReader;
import io.camunda.search.clients.reader.TenantMemberDocumentReader;
import io.camunda.search.clients.reader.UserReader;
import io.camunda.search.entities.UserEntity;
import io.camunda.search.query.SearchQueryResult;
import io.camunda.search.query.UserQuery;
import io.camunda.security.reader.ResourceAccessChecks;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import io.camunda.zeebe.protocol.record.value.EntityType;
import java.util.Set;

public class UserDocumentReader
extends DocumentBasedReader
implements UserReader {
    private final RoleMemberDocumentReader roleMemberReader;
    private final TenantMemberDocumentReader tenantMemberReader;
    private final GroupMemberDocumentReader groupMemberReader;

    public UserDocumentReader(SearchClientBasedQueryExecutor executor, IndexDescriptor indexDescriptor, RoleMemberDocumentReader roleMemberReader, TenantMemberDocumentReader tenantMemberReader, GroupMemberDocumentReader groupMemberReader) {
        super(executor, indexDescriptor);
        this.roleMemberReader = roleMemberReader;
        this.tenantMemberReader = tenantMemberReader;
        this.groupMemberReader = groupMemberReader;
    }

    public UserEntity getById(String id, ResourceAccessChecks resourceAccessChecks) {
        return (UserEntity)this.getSearchExecutor().getById(id, io.camunda.webapps.schema.entities.usermanagement.UserEntity.class, this.indexDescriptor.getFullQualifiedName());
    }

    public SearchQueryResult<UserEntity> search(UserQuery query, ResourceAccessChecks resourceAccessChecks) {
        return this.getSearchExecutor().search(this.applyFilters(query), io.camunda.webapps.schema.entities.usermanagement.UserEntity.class, resourceAccessChecks);
    }

    private UserQuery applyFilters(UserQuery userQuery) {
        if (userQuery.filter().tenantId() != null) {
            return this.expandTenantFilter(userQuery);
        }
        if (userQuery.filter().groupId() != null) {
            return this.expandGroupFilter(userQuery);
        }
        if (userQuery.filter().roleId() != null) {
            return this.expandRoleFilter(userQuery);
        }
        return userQuery;
    }

    private UserQuery expandTenantFilter(UserQuery userQuery) {
        Set<String> usernames = this.tenantMemberReader.getTenantMembers(userQuery.filter().tenantId(), EntityType.USER);
        return userQuery.toBuilder().filter(userQuery.filter().toBuilder().usernames(usernames).build()).build();
    }

    private UserQuery expandGroupFilter(UserQuery userQuery) {
        Set<String> usernames = this.groupMemberReader.getGroupMembers(userQuery.filter().groupId(), EntityType.USER);
        return userQuery.toBuilder().filter(userQuery.filter().toBuilder().usernames(usernames).build()).build();
    }

    private UserQuery expandRoleFilter(UserQuery userQuery) {
        Set<String> usernames = this.roleMemberReader.getRoleMembers(userQuery.filter().roleId(), EntityType.USER);
        return userQuery.toBuilder().filter(userQuery.filter().toBuilder().usernames(usernames).build()).build();
    }
}

