/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.reader;

import io.camunda.search.clients.SearchClientBasedQueryExecutor;
import io.camunda.search.clients.reader.DocumentBasedReader;
import io.camunda.search.clients.reader.IncidentDocumentReader;
import io.camunda.search.clients.reader.ProcessInstanceReader;
import io.camunda.search.entities.ProcessInstanceEntity;
import io.camunda.search.filter.Operation;
import io.camunda.search.filter.ProcessInstanceFilter;
import io.camunda.search.query.ProcessInstanceQuery;
import io.camunda.search.query.SearchQueryResult;
import io.camunda.security.reader.ResourceAccessChecks;
import io.camunda.util.ObjectBuilder;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import io.camunda.webapps.schema.entities.listview.ProcessInstanceForListViewEntity;
import java.util.ArrayList;
import java.util.List;

public class ProcessInstanceDocumentReader
extends DocumentBasedReader
implements ProcessInstanceReader {
    private final IncidentDocumentReader incidentReader;

    public ProcessInstanceDocumentReader(SearchClientBasedQueryExecutor executor, IndexDescriptor indexDescriptor, IncidentDocumentReader incidentReader) {
        super(executor, indexDescriptor);
        this.incidentReader = incidentReader;
    }

    public ProcessInstanceEntity getByKey(long key, ResourceAccessChecks resourceAccessChecks) {
        return (ProcessInstanceEntity)this.getSearchExecutor().getByQuery(ProcessInstanceQuery.of(b -> (ObjectBuilder)b.filter(f -> f.processInstanceKeys(Long.valueOf(key), new Long[0])).singleResult()), ProcessInstanceForListViewEntity.class);
    }

    public SearchQueryResult<ProcessInstanceEntity> search(ProcessInstanceQuery query, ResourceAccessChecks resourceAccessChecks) {
        ProcessInstanceFilter filter = query.filter();
        if (filter.incidentErrorHashCodeOperations() != null && !filter.incidentErrorHashCodeOperations().isEmpty() && ((filter = this.normalizePITopLevelIncidentHashCodes(filter, resourceAccessChecks)).incidentErrorHashCodeOperations().isEmpty() || filter.errorMessageOperations().isEmpty())) {
            return SearchQueryResult.empty();
        }
        if (filter.orFilters() != null && !filter.orFilters().isEmpty()) {
            List<ProcessInstanceFilter> normalizedOr = this.normalizePIOrFilterErrorHashCodes(filter.orFilters(), resourceAccessChecks);
            if (normalizedOr.isEmpty()) {
                return SearchQueryResult.empty();
            }
            filter = filter.toBuilder().orFilters(normalizedOr).build();
        }
        ProcessInstanceFilter finalFilter = filter;
        ProcessInstanceQuery updatedQuery = ProcessInstanceQuery.of(q -> ((ProcessInstanceQuery.Builder)q.filter(finalFilter).sort(query.sort()).page(query.page())).resultConfig(query.resultConfig()));
        return this.executeSearchProcessInstances(updatedQuery, resourceAccessChecks);
    }

    public SearchQueryResult<ProcessInstanceEntity> executeSearchProcessInstances(ProcessInstanceQuery query, ResourceAccessChecks resourceAccessChecks) {
        return this.getSearchExecutor().search(query, ProcessInstanceForListViewEntity.class, resourceAccessChecks);
    }

    private ProcessInstanceFilter normalizePITopLevelIncidentHashCodes(ProcessInstanceFilter filter, ResourceAccessChecks resourceAccessChecks) {
        if (filter.incidentErrorHashCodeOperations() == null || filter.incidentErrorHashCodeOperations().isEmpty()) {
            return filter;
        }
        String resolvedErrorMessage = this.incidentReader.findErrorMessageByErrorHashCodes(filter.incidentErrorHashCodeOperations(), resourceAccessChecks);
        if (resolvedErrorMessage == null || resolvedErrorMessage.isBlank()) {
            return filter.toBuilder().incidentErrorHashCode(null, new Integer[0]).build();
        }
        ArrayList<Operation> existingOps = filter.errorMessageOperations() != null ? new ArrayList<Operation>(filter.errorMessageOperations()) : new ArrayList();
        existingOps.add(Operation.eq((Object)resolvedErrorMessage));
        return filter.toBuilder().incidentErrorHashCode(null, new Integer[0]).replaceErrorMessageOperations(existingOps).build();
    }

    private List<ProcessInstanceFilter> normalizePIOrFilterErrorHashCodes(List<ProcessInstanceFilter> orFilters, ResourceAccessChecks resourceAccessChecks) {
        ArrayList<ProcessInstanceFilter> normalized = new ArrayList<ProcessInstanceFilter>();
        for (ProcessInstanceFilter subFilter : orFilters) {
            if (subFilter.incidentErrorHashCodeOperations() == null || subFilter.incidentErrorHashCodeOperations().isEmpty()) {
                normalized.add(subFilter);
                continue;
            }
            String resolvedErrorMessage = this.incidentReader.findErrorMessageByErrorHashCodes(subFilter.incidentErrorHashCodeOperations(), resourceAccessChecks);
            if (resolvedErrorMessage == null || resolvedErrorMessage.isBlank()) continue;
            ArrayList<Operation> existingOps = subFilter.errorMessageOperations() != null ? new ArrayList<Operation>(subFilter.errorMessageOperations()) : new ArrayList();
            existingOps.add(Operation.eq((Object)resolvedErrorMessage));
            ProcessInstanceFilter updatedSubFilter = subFilter.toBuilder().incidentErrorHashCode(null, new Integer[0]).replaceErrorMessageOperations(existingOps).build();
            normalized.add(updatedSubFilter);
        }
        return normalized;
    }
}

