/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.reader;

import io.camunda.search.clients.SearchClientBasedQueryExecutor;
import io.camunda.search.clients.reader.DocumentBasedReader;
import io.camunda.search.clients.reader.GroupMemberReader;
import io.camunda.search.entities.GroupMemberEntity;
import io.camunda.search.query.GroupQuery;
import io.camunda.search.query.SearchQueryResult;
import io.camunda.security.reader.ResourceAccessChecks;
import io.camunda.util.ObjectBuilder;
import io.camunda.webapps.schema.descriptors.IndexDescriptor;
import io.camunda.zeebe.protocol.record.value.EntityType;
import java.util.Set;
import java.util.stream.Collectors;

public class GroupMemberDocumentReader
extends DocumentBasedReader
implements GroupMemberReader {
    public GroupMemberDocumentReader(SearchClientBasedQueryExecutor executor, IndexDescriptor indexDescriptor) {
        super(executor, indexDescriptor);
    }

    public SearchQueryResult<GroupMemberEntity> search(GroupQuery query, ResourceAccessChecks resourceAccessChecks) {
        return this.getSearchExecutor().search(query, io.camunda.webapps.schema.entities.usermanagement.GroupMemberEntity.class, resourceAccessChecks);
    }

    public Set<String> getGroupMembers(String groupId, EntityType entityType) {
        GroupQuery groupMemberQuery = GroupQuery.of(b -> (ObjectBuilder)b.filter(f -> f.joinParentId(groupId).memberType(entityType)).unlimited());
        return this.search(groupMemberQuery, ResourceAccessChecks.disabled()).items().stream().map(GroupMemberEntity::id).collect(Collectors.toSet());
    }
}

