/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.query;

import io.camunda.search.clients.query.SearchBoolQuery;
import io.camunda.search.clients.query.SearchConstantScoreQuery;
import io.camunda.search.clients.query.SearchExistsQuery;
import io.camunda.search.clients.query.SearchHasChildQuery;
import io.camunda.search.clients.query.SearchHasParentQuery;
import io.camunda.search.clients.query.SearchIdsQuery;
import io.camunda.search.clients.query.SearchMatchAllQuery;
import io.camunda.search.clients.query.SearchMatchNoneQuery;
import io.camunda.search.clients.query.SearchMatchPhraseQuery;
import io.camunda.search.clients.query.SearchMatchQuery;
import io.camunda.search.clients.query.SearchPrefixQuery;
import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchRangeQuery;
import io.camunda.search.clients.query.SearchTermQuery;
import io.camunda.search.clients.query.SearchTermsQuery;
import io.camunda.search.clients.query.SearchWildcardQuery;
import io.camunda.search.clients.types.TypedValue;
import io.camunda.search.entities.ValueTypeEnum;
import io.camunda.search.filter.Operation;
import io.camunda.search.filter.Operator;
import io.camunda.search.filter.UntypedOperation;
import io.camunda.util.CollectionUtil;
import io.camunda.util.ObjectBuilder;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class SearchQueryBuilders {
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZZ";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");

    private SearchQueryBuilders() {
    }

    private static SearchQuery must(List<SearchQuery> queries) {
        return SearchQueryBuilders.bool().must(queries).build().toSearchQuery();
    }

    private static SearchQuery should(List<SearchQuery> queries) {
        return SearchQueryBuilders.bool().should(queries).build().toSearchQuery();
    }

    private static SearchQuery mustNot(List<SearchQuery> queries) {
        return SearchQueryBuilders.bool().mustNot(queries).build().toSearchQuery();
    }

    private static SearchQuery mustNot(SearchQuery ... queries) {
        return SearchQueryBuilders.bool().mustNot(List.of(queries)).build().toSearchQuery();
    }

    private static SearchQuery map(List<SearchQuery> queries, Function<List<SearchQuery>, SearchQuery> mapper) {
        List nonNullQueries = CollectionUtil.withoutNull(queries);
        if (nonNullQueries == null || nonNullQueries.isEmpty()) {
            return null;
        }
        if (nonNullQueries.size() == 1) {
            return (SearchQuery)nonNullQueries.getFirst();
        }
        return mapper.apply(nonNullQueries);
    }

    public static SearchBoolQuery.Builder bool() {
        return new SearchBoolQuery.Builder();
    }

    public static SearchBoolQuery bool(Function<SearchBoolQuery.Builder, ObjectBuilder<SearchBoolQuery>> fn) {
        return (SearchBoolQuery)fn.apply(SearchQueryBuilders.bool()).build();
    }

    public static SearchQuery and(SearchQuery query, SearchQuery ... queries) {
        return SearchQueryBuilders.and((List<SearchQuery>)CollectionUtil.collectValues((Object)query, (Object[])queries));
    }

    public static SearchQuery and(List<SearchQuery> queries) {
        return SearchQueryBuilders.map(queries, SearchQueryBuilders::must);
    }

    @SafeVarargs
    public static SearchQuery and(List<SearchQuery> ... queries) {
        return SearchQueryBuilders.map(Arrays.stream(queries).flatMap(Collection::stream).toList(), SearchQueryBuilders::must);
    }

    public static SearchQuery not(SearchQuery query, SearchQuery ... queries) {
        return SearchQueryBuilders.not(CollectionUtil.collectValues((Object)query, (Object[])queries));
    }

    public static SearchQuery not(List<SearchQuery> queries) {
        List nonNullQueries = CollectionUtil.withoutNull(queries);
        if (nonNullQueries != null && !nonNullQueries.isEmpty()) {
            return SearchQueryBuilders.mustNot(queries);
        }
        return null;
    }

    public static SearchQuery or(SearchQuery query, SearchQuery ... queries) {
        return SearchQueryBuilders.or(CollectionUtil.collectValues((Object)query, (Object[])queries));
    }

    public static SearchQuery or(List<SearchQuery> queries) {
        return SearchQueryBuilders.map(queries, SearchQueryBuilders::should);
    }

    public static SearchConstantScoreQuery.Builder constantScore() {
        return new SearchConstantScoreQuery.Builder();
    }

    public static SearchConstantScoreQuery constantScore(Function<SearchConstantScoreQuery.Builder, ObjectBuilder<SearchConstantScoreQuery>> fn) {
        return (SearchConstantScoreQuery)fn.apply(SearchQueryBuilders.constantScore()).build();
    }

    public static SearchQuery constantScore(SearchQuery query) {
        return SearchQueryBuilders.constantScore((SearchConstantScoreQuery.Builder q) -> q.filter(query)).toSearchQuery();
    }

    public static SearchExistsQuery.Builder exists() {
        return new SearchExistsQuery.Builder();
    }

    public static SearchExistsQuery exists(Function<SearchExistsQuery.Builder, ObjectBuilder<SearchExistsQuery>> fn) {
        return (SearchExistsQuery)fn.apply(SearchQueryBuilders.exists()).build();
    }

    public static SearchQuery exists(String field) {
        return SearchQueryBuilders.exists((SearchExistsQuery.Builder q) -> q.field(field)).toSearchQuery();
    }

    public static SearchHasChildQuery.Builder hasChild() {
        return new SearchHasChildQuery.Builder();
    }

    public static SearchHasChildQuery hasChild(Function<SearchHasChildQuery.Builder, ObjectBuilder<SearchHasChildQuery>> fn) {
        return (SearchHasChildQuery)fn.apply(SearchQueryBuilders.hasChild()).build();
    }

    public static SearchIdsQuery.Builder ids() {
        return new SearchIdsQuery.Builder();
    }

    public static SearchIdsQuery ids(Function<SearchIdsQuery.Builder, ObjectBuilder<SearchIdsQuery>> fn) {
        return (SearchIdsQuery)fn.apply(SearchQueryBuilders.ids()).build();
    }

    public static SearchQuery ids(List<String> ids) {
        return SearchQueryBuilders.ids((SearchIdsQuery.Builder q) -> q.values(CollectionUtil.withoutNull((Collection)ids))).toSearchQuery();
    }

    public static SearchQuery ids(Collection<String> ids) {
        return SearchQueryBuilders.ids(new ArrayList<String>(Objects.requireNonNullElse(ids, List.of())));
    }

    public static SearchQuery ids(String ... ids) {
        return SearchQueryBuilders.ids(List.of(Objects.requireNonNullElse(ids, new String[0])));
    }

    public static SearchMatchQuery.Builder match() {
        return new SearchMatchQuery.Builder();
    }

    public static SearchMatchQuery match(Function<SearchMatchQuery.Builder, ObjectBuilder<SearchMatchQuery>> fn) {
        return (SearchMatchQuery)fn.apply(SearchQueryBuilders.match()).build();
    }

    public static <A> SearchQuery match(String field, String value, SearchMatchQuery.SearchMatchQueryOperator operator) {
        return SearchQueryBuilders.match(q -> q.field(field).query(value).operator(operator)).toSearchQuery();
    }

    public static SearchQuery matchAll() {
        return new SearchMatchAllQuery.Builder().build().toSearchQuery();
    }

    public static SearchQuery matchNone() {
        return new SearchMatchNoneQuery.Builder().build().toSearchQuery();
    }

    public static SearchMatchPhraseQuery.Builder matchPhrase() {
        return new SearchMatchPhraseQuery.Builder();
    }

    public static SearchMatchPhraseQuery matchPhrase(Function<SearchMatchPhraseQuery.Builder, ObjectBuilder<SearchMatchPhraseQuery>> fn) {
        return (SearchMatchPhraseQuery)fn.apply(SearchQueryBuilders.matchPhrase()).build();
    }

    public static <A> SearchQuery matchPhrase(String field, String value) {
        return SearchQueryBuilders.matchPhrase(q -> q.field(field).query(value)).toSearchQuery();
    }

    public static SearchPrefixQuery.Builder prefix() {
        return new SearchPrefixQuery.Builder();
    }

    public static SearchPrefixQuery prefix(Function<SearchPrefixQuery.Builder, ObjectBuilder<SearchPrefixQuery>> fn) {
        return (SearchPrefixQuery)fn.apply(SearchQueryBuilders.prefix()).build();
    }

    public static SearchQuery prefix(String field, String value) {
        return SearchQueryBuilders.prefix(q -> q.field(field).value(value)).toSearchQuery();
    }

    public static SearchQuery.Builder query() {
        return new SearchQuery.Builder();
    }

    public static SearchQuery query(Function<SearchQuery.Builder, ObjectBuilder<SearchQuery>> fn) {
        return (SearchQuery)fn.apply(SearchQueryBuilders.query()).build();
    }

    public static SearchRangeQuery.Builder range() {
        return new SearchRangeQuery.Builder();
    }

    public static SearchRangeQuery range(Function<SearchRangeQuery.Builder, ObjectBuilder<SearchRangeQuery>> fn) {
        return (SearchRangeQuery)fn.apply(SearchQueryBuilders.range()).build();
    }

    public static <A> SearchQuery gt(String field, A gt) {
        return SearchRangeQuery.of(q -> q.field(field).gt(gt)).toSearchQuery();
    }

    public static <A> SearchQuery gte(String field, A gte) {
        return SearchRangeQuery.of(q -> q.field(field).gte(gte)).toSearchQuery();
    }

    public static <A> SearchQuery lt(String field, A lt) {
        return SearchRangeQuery.of(q -> q.field(field).lt(lt)).toSearchQuery();
    }

    public static <A> SearchQuery lte(String field, A lte) {
        return SearchRangeQuery.of(q -> q.field(field).lte(lte)).toSearchQuery();
    }

    public static <A> SearchQuery gteLte(String field, A gte, A lte) {
        return SearchRangeQuery.of(q -> q.field(field).gte(gte).lte(lte)).toSearchQuery();
    }

    public static <A> SearchQuery gtLte(String field, A gt, A lte) {
        return SearchRangeQuery.of(q -> q.field(field).gt(gt).lte(lte)).toSearchQuery();
    }

    public static SearchQuery hasChildQuery(String type, SearchQuery query) {
        return SearchQueryBuilders.hasChild(q -> q.query(query).type(type)).toSearchQuery();
    }

    public static SearchTermQuery.Builder term() {
        return new SearchTermQuery.Builder();
    }

    public static SearchTermQuery term(Function<SearchTermQuery.Builder, ObjectBuilder<SearchTermQuery>> fn) {
        return (SearchTermQuery)fn.apply(SearchQueryBuilders.term()).build();
    }

    public static SearchQuery term(String field, Integer value) {
        return SearchQueryBuilders.term(q -> q.field(field).value(value)).toSearchQuery();
    }

    public static SearchQuery term(String field, Long value) {
        return SearchQueryBuilders.term(q -> q.field(field).value(value)).toSearchQuery();
    }

    public static SearchQuery term(String field, Double value) {
        return SearchQueryBuilders.term(q -> q.field(field).value(value)).toSearchQuery();
    }

    public static SearchQuery term(String field, String value) {
        return SearchQueryBuilders.term(q -> q.field(field).value(value)).toSearchQuery();
    }

    public static SearchQuery term(String field, boolean value) {
        return SearchQueryBuilders.term(q -> q.field(field).value(value)).toSearchQuery();
    }

    public static SearchQuery term(String field, TypedValue value) {
        return SearchQueryBuilders.term(q -> q.field(field).value(value)).toSearchQuery();
    }

    public static SearchTermsQuery.Builder terms() {
        return new SearchTermsQuery.Builder();
    }

    public static SearchTermsQuery terms(Function<SearchTermsQuery.Builder, ObjectBuilder<SearchTermsQuery>> fn) {
        return (SearchTermsQuery)fn.apply(SearchQueryBuilders.terms()).build();
    }

    public static <C extends Collection<Integer>> SearchQuery intTerms(String field, C values) {
        List fieldValues = CollectionUtil.withoutNull(values);
        if (fieldValues == null || fieldValues.isEmpty()) {
            return null;
        }
        if (fieldValues.size() == 1) {
            return SearchQueryBuilders.term(field, (Integer)fieldValues.getFirst());
        }
        return SearchTermsQuery.of(q -> q.field(field).intTerms(fieldValues)).toSearchQuery();
    }

    public static <C extends Collection<Long>> SearchQuery longTerms(String field, C values) {
        List fieldValues = CollectionUtil.withoutNull(values);
        if (fieldValues == null || fieldValues.isEmpty()) {
            return null;
        }
        if (fieldValues.size() == 1) {
            return SearchQueryBuilders.term(field, (Long)fieldValues.getFirst());
        }
        return SearchTermsQuery.of(q -> q.field(field).longTerms(fieldValues)).toSearchQuery();
    }

    public static SearchQuery stringTerms(String field, Collection<String> values) {
        List fieldValues = CollectionUtil.withoutNull(values);
        if (fieldValues == null || fieldValues.isEmpty()) {
            return null;
        }
        if (fieldValues.size() == 1) {
            return SearchQueryBuilders.term(field, (String)fieldValues.getFirst());
        }
        return SearchTermsQuery.of(q -> q.field(field).stringTerms(fieldValues)).toSearchQuery();
    }

    public static SearchQuery objectTerms(String field, Collection<Object> values) {
        List fieldValues = CollectionUtil.withoutNull(values);
        if (fieldValues == null || fieldValues.isEmpty()) {
            return null;
        }
        if (fieldValues.size() == 1) {
            return SearchQueryBuilders.term(field, TypedValue.toTypedValue(fieldValues.getFirst()));
        }
        List typedValues = fieldValues.stream().map(TypedValue::toTypedValue).collect(Collectors.toList());
        return SearchTermsQuery.of(q -> q.field(field).terms(typedValues)).toSearchQuery();
    }

    private static IllegalStateException unexpectedOperation(String type, Operator op) {
        return new IllegalStateException("Unexpected %s operation: %s".formatted(type, op));
    }

    public static <C extends List<Operation<Integer>>> List<SearchQuery> intOperations(String field, C operations) {
        if (operations == null || operations.isEmpty()) {
            return List.of();
        }
        ArrayList<SearchQuery> queries = new ArrayList<SearchQuery>();
        SearchRangeQuery.Builder rangeQueryBuilder = null;
        block12: for (Operation<Integer> op : operations) {
            switch (op.operator()) {
                case EQUALS: {
                    queries.add(SearchQueryBuilders.term(field, (Integer)op.value()));
                    continue block12;
                }
                case NOT_EQUALS: {
                    queries.add(SearchQueryBuilders.mustNot(SearchQueryBuilders.term(field, (Integer)op.value())));
                    continue block12;
                }
                case EXISTS: {
                    queries.add(SearchQueryBuilders.exists(field));
                    continue block12;
                }
                case NOT_EXISTS: {
                    queries.add(SearchQueryBuilders.mustNot(SearchQueryBuilders.exists(field)));
                    continue block12;
                }
                case GREATER_THAN: {
                    rangeQueryBuilder = SearchQueryBuilders.buildRangeQuery(rangeQueryBuilder, field, b -> b.gt(op.value()));
                    continue block12;
                }
                case GREATER_THAN_EQUALS: {
                    rangeQueryBuilder = SearchQueryBuilders.buildRangeQuery(rangeQueryBuilder, field, b -> b.gte(op.value()));
                    continue block12;
                }
                case LOWER_THAN: {
                    rangeQueryBuilder = SearchQueryBuilders.buildRangeQuery(rangeQueryBuilder, field, b -> b.lt(op.value()));
                    continue block12;
                }
                case LOWER_THAN_EQUALS: {
                    rangeQueryBuilder = SearchQueryBuilders.buildRangeQuery(rangeQueryBuilder, field, b -> b.lte(op.value()));
                    continue block12;
                }
                case IN: {
                    queries.add(SearchQueryBuilders.intTerms(field, op.values()));
                    continue block12;
                }
                case NOT_IN: {
                    queries.add(SearchQueryBuilders.mustNot(SearchQueryBuilders.intTerms(field, op.values())));
                    continue block12;
                }
            }
            throw SearchQueryBuilders.unexpectedOperation("Integer", op.operator());
        }
        if (rangeQueryBuilder != null) {
            queries.add(rangeQueryBuilder.build().toSearchQuery());
        }
        return queries;
    }

    public static <C extends List<Operation<Long>>> List<SearchQuery> longOperations(String field, C operations) {
        if (operations == null || operations.isEmpty()) {
            return List.of();
        }
        ArrayList<SearchQuery> queries = new ArrayList<SearchQuery>();
        SearchRangeQuery.Builder rangeQueryBuilder = null;
        block12: for (Operation<Long> op : operations) {
            switch (op.operator()) {
                case EQUALS: {
                    queries.add(SearchQueryBuilders.term(field, (Long)op.value()));
                    continue block12;
                }
                case NOT_EQUALS: {
                    queries.add(SearchQueryBuilders.mustNot(SearchQueryBuilders.term(field, (Long)op.value())));
                    continue block12;
                }
                case EXISTS: {
                    queries.add(SearchQueryBuilders.exists(field));
                    continue block12;
                }
                case NOT_EXISTS: {
                    queries.add(SearchQueryBuilders.mustNot(SearchQueryBuilders.exists(field)));
                    continue block12;
                }
                case GREATER_THAN: {
                    rangeQueryBuilder = SearchQueryBuilders.buildRangeQuery(rangeQueryBuilder, field, b -> b.gt(op.value()));
                    continue block12;
                }
                case GREATER_THAN_EQUALS: {
                    rangeQueryBuilder = SearchQueryBuilders.buildRangeQuery(rangeQueryBuilder, field, b -> b.gte(op.value()));
                    continue block12;
                }
                case LOWER_THAN: {
                    rangeQueryBuilder = SearchQueryBuilders.buildRangeQuery(rangeQueryBuilder, field, b -> b.lt(op.value()));
                    continue block12;
                }
                case LOWER_THAN_EQUALS: {
                    rangeQueryBuilder = SearchQueryBuilders.buildRangeQuery(rangeQueryBuilder, field, b -> b.lte(op.value()));
                    continue block12;
                }
                case IN: {
                    queries.add(SearchQueryBuilders.longTerms(field, op.values()));
                    continue block12;
                }
                case NOT_IN: {
                    queries.add(SearchQueryBuilders.mustNot(SearchQueryBuilders.longTerms(field, op.values())));
                    continue block12;
                }
            }
            throw SearchQueryBuilders.unexpectedOperation("Long", op.operator());
        }
        if (rangeQueryBuilder != null) {
            queries.add(rangeQueryBuilder.build().toSearchQuery());
        }
        return queries;
    }

    public static <C extends List<Operation<String>>> List<SearchQuery> stringOperations(String field, C operations) {
        if (operations == null || operations.isEmpty()) {
            return List.of();
        }
        ArrayList<SearchQuery> searchQueries = new ArrayList<SearchQuery>();
        operations.forEach(op -> searchQueries.add(switch (op.operator()) {
            case Operator.EQUALS -> SearchQueryBuilders.term(field, (String)op.value());
            case Operator.NOT_EQUALS -> SearchQueryBuilders.mustNot(SearchQueryBuilders.term(field, (String)op.value()));
            case Operator.EXISTS -> SearchQueryBuilders.exists(field);
            case Operator.NOT_EXISTS -> SearchQueryBuilders.mustNot(SearchQueryBuilders.exists(field));
            case Operator.IN -> SearchQueryBuilders.stringTerms(field, op.values());
            case Operator.NOT_IN -> SearchQueryBuilders.mustNot(SearchQueryBuilders.stringTerms(field, op.values()));
            case Operator.LIKE -> SearchQueryBuilders.wildcardQuery(field, (String)op.value());
            default -> throw SearchQueryBuilders.unexpectedOperation("String", op.operator());
        }));
        return searchQueries;
    }

    public static <C extends List<Operation<String>>> List<SearchQuery> stringMatchPhraseOperations(String field, C operations) {
        if (operations == null || operations.isEmpty()) {
            return List.of();
        }
        return operations.stream().map(op -> switch (op.operator()) {
            case Operator.EQUALS -> SearchQueryBuilders.matchPhrase(field, (String)op.value());
            case Operator.NOT_EQUALS -> SearchQueryBuilders.mustNot(SearchQueryBuilders.matchPhrase(field, (String)op.value()));
            case Operator.EXISTS -> SearchQueryBuilders.exists(field);
            case Operator.NOT_EXISTS -> SearchQueryBuilders.mustNot(SearchQueryBuilders.exists(field));
            case Operator.IN -> SearchQueryBuilders.or(op.values().stream().map(value -> SearchQueryBuilders.matchPhrase(field, value)).toList());
            case Operator.LIKE -> SearchQueryBuilders.wildcardQuery(field, Objects.requireNonNull((String)op.value()).toLowerCase());
            default -> throw SearchQueryBuilders.unexpectedOperation("String", op.operator());
        }).toList();
    }

    public static <C extends List<Operation<String>>> List<SearchQuery> stringMatchPhraseWithHasChildOperations(String field, C operations, String childType) {
        if (operations == null || operations.isEmpty()) {
            return List.of();
        }
        return operations.stream().map(op -> switch (op.operator()) {
            case Operator.EQUALS -> SearchQueryBuilders.hasChildQuery(childType, SearchQueryBuilders.matchPhrase(field, (String)op.value()));
            case Operator.NOT_EQUALS -> SearchQueryBuilders.hasChildQuery(childType, SearchQueryBuilders.bool(b -> b.must(List.of(SearchQueryBuilders.exists(field))).mustNot(List.of(SearchQueryBuilders.matchPhrase(field, (String)op.value())))).toSearchQuery());
            case Operator.EXISTS -> SearchQueryBuilders.hasChildQuery(childType, SearchQueryBuilders.bool(b -> b.must(List.of(SearchQueryBuilders.exists(field)))).toSearchQuery());
            case Operator.NOT_EXISTS -> SearchQueryBuilders.hasChildQuery(childType, SearchQueryBuilders.bool(b -> b.must(List.of(SearchQueryBuilders.exists(field))).mustNot(List.of(SearchQueryBuilders.exists(field)))).toSearchQuery());
            case Operator.IN -> SearchQueryBuilders.hasChildQuery(childType, SearchQueryBuilders.or(op.values().stream().map(value -> SearchQueryBuilders.matchPhrase(field, value)).toList()));
            case Operator.LIKE -> SearchQueryBuilders.hasChildQuery(childType, SearchQueryBuilders.wildcardQuery(field, Objects.requireNonNull((String)op.value()).toLowerCase()));
            default -> throw SearchQueryBuilders.unexpectedOperation("String", op.operator());
        }).toList();
    }

    private static String formatDate(OffsetDateTime dateTime) {
        return DATE_TIME_FORMATTER.format(dateTime);
    }

    private static SearchRangeQuery.Builder buildRangeQuery(SearchRangeQuery.Builder builder, String field, Consumer<SearchRangeQuery.Builder> builderConsumer) {
        if (builder == null) {
            builder = new SearchRangeQuery.Builder().field(field).format(DATE_TIME_FORMAT);
        }
        builderConsumer.accept(builder);
        return builder;
    }

    public static <C extends List<Operation<OffsetDateTime>>> List<SearchQuery> dateTimeOperations(String field, C operations) {
        if (operations == null || operations.isEmpty()) {
            return List.of();
        }
        ArrayList<SearchQuery> queries = new ArrayList<SearchQuery>();
        SearchRangeQuery.Builder rangeQueryBuilder = null;
        block10: for (Operation<OffsetDateTime> op : operations) {
            switch (op.operator()) {
                case EQUALS: {
                    queries.add(SearchQueryBuilders.term(field, SearchQueryBuilders.formatDate((OffsetDateTime)op.value())));
                    continue block10;
                }
                case NOT_EQUALS: {
                    queries.add(SearchQueryBuilders.mustNot(SearchQueryBuilders.term(field, SearchQueryBuilders.formatDate((OffsetDateTime)op.value()))));
                    continue block10;
                }
                case EXISTS: {
                    queries.add(SearchQueryBuilders.exists(field));
                    continue block10;
                }
                case NOT_EXISTS: {
                    queries.add(SearchQueryBuilders.mustNot(SearchQueryBuilders.exists(field)));
                    continue block10;
                }
                case GREATER_THAN: {
                    rangeQueryBuilder = SearchQueryBuilders.buildRangeQuery(rangeQueryBuilder, field, b -> b.gt(SearchQueryBuilders.formatDate((OffsetDateTime)op.value())));
                    continue block10;
                }
                case GREATER_THAN_EQUALS: {
                    rangeQueryBuilder = SearchQueryBuilders.buildRangeQuery(rangeQueryBuilder, field, b -> b.gte(SearchQueryBuilders.formatDate((OffsetDateTime)op.value())));
                    continue block10;
                }
                case LOWER_THAN: {
                    rangeQueryBuilder = SearchQueryBuilders.buildRangeQuery(rangeQueryBuilder, field, b -> b.lt(SearchQueryBuilders.formatDate((OffsetDateTime)op.value())));
                    continue block10;
                }
                case LOWER_THAN_EQUALS: {
                    rangeQueryBuilder = SearchQueryBuilders.buildRangeQuery(rangeQueryBuilder, field, b -> b.lte(SearchQueryBuilders.formatDate((OffsetDateTime)op.value())));
                    continue block10;
                }
            }
            throw SearchQueryBuilders.unexpectedOperation("Date", op.operator());
        }
        if (rangeQueryBuilder != null) {
            queries.add(rangeQueryBuilder.build().toSearchQuery());
        }
        return queries;
    }

    public static <C extends UntypedOperation> SearchQuery variableOperation(String field, C operation) {
        SearchQuery res;
        switch (operation.operator()) {
            case EQUALS: {
                SearchQuery searchQuery = SearchQueryBuilders.term(field, TypedValue.toTypedValue(operation.value()));
                break;
            }
            case NOT_EQUALS: {
                SearchQuery searchQuery = SearchQueryBuilders.mustNot(SearchQueryBuilders.term(field, TypedValue.toTypedValue(operation.value())));
                break;
            }
            case EXISTS: {
                SearchQuery searchQuery = SearchQueryBuilders.exists(field);
                break;
            }
            case NOT_EXISTS: {
                SearchQuery searchQuery = SearchQueryBuilders.mustNot(SearchQueryBuilders.exists(field));
                break;
            }
            case IN: {
                SearchQuery searchQuery = SearchQueryBuilders.objectTerms(field, operation.values());
                break;
            }
            default: {
                SearchQuery searchQuery = res = null;
            }
        }
        if (res != null) {
            return res;
        }
        ValueTypeEnum type = operation.type();
        if (type.equals((Object)ValueTypeEnum.LONG) || type.equals((Object)ValueTypeEnum.DOUBLE)) {
            SearchRangeQuery.Builder rangeQueryBuilder = null;
            switch (operation.operator()) {
                case GREATER_THAN: {
                    rangeQueryBuilder = SearchQueryBuilders.buildRangeQuery(rangeQueryBuilder, field, b -> b.gt(operation.value()));
                    break;
                }
                case GREATER_THAN_EQUALS: {
                    rangeQueryBuilder = SearchQueryBuilders.buildRangeQuery(rangeQueryBuilder, field, b -> b.gte(operation.value()));
                    break;
                }
                case LOWER_THAN: {
                    rangeQueryBuilder = SearchQueryBuilders.buildRangeQuery(rangeQueryBuilder, field, b -> b.lt(operation.value()));
                    break;
                }
                case LOWER_THAN_EQUALS: {
                    rangeQueryBuilder = SearchQueryBuilders.buildRangeQuery(rangeQueryBuilder, field, b -> b.lte(operation.value()));
                    break;
                }
                default: {
                    throw SearchQueryBuilders.unexpectedOperation("Variable (numeric)", operation.operator());
                }
            }
            if (rangeQueryBuilder != null) {
                return rangeQueryBuilder.build().toSearchQuery();
            }
        }
        if (type.equals((Object)ValueTypeEnum.STRING)) {
            switch (operation.operator()) {
                case LIKE: {
                    break;
                }
                default: {
                    throw SearchQueryBuilders.unexpectedOperation("Variable (string)", operation.operator());
                }
            }
            return SearchQueryBuilders.wildcardQuery(field, (String)operation.value());
        }
        return null;
    }

    public static <C extends List<UntypedOperation>> List<SearchQuery> variableOperations(String field, C operations) {
        if (operations == null || operations.isEmpty()) {
            return List.of();
        }
        return operations.stream().map(op -> SearchQueryBuilders.variableOperation(field, op)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static SearchWildcardQuery.Builder wildcard() {
        return new SearchWildcardQuery.Builder();
    }

    public static SearchWildcardQuery wildcard(Function<SearchWildcardQuery.Builder, ObjectBuilder<SearchWildcardQuery>> fn) {
        return (SearchWildcardQuery)fn.apply(SearchQueryBuilders.wildcard()).build();
    }

    public static SearchQuery wildcardQuery(String field, String value) {
        return SearchQueryBuilders.wildcard(q -> q.field(field).value(value)).toSearchQuery();
    }

    public static SearchHasParentQuery.Builder hasParent() {
        return new SearchHasParentQuery.Builder();
    }

    public static SearchHasParentQuery hasParent(Function<SearchHasParentQuery.Builder, ObjectBuilder<SearchHasParentQuery>> fn) {
        return (SearchHasParentQuery)fn.apply(SearchQueryBuilders.hasParent()).build();
    }

    public static SearchQuery hasParentQuery(String parent, SearchQuery query) {
        return SearchQueryBuilders.hasParent(q -> q.parentType(parent).query(query)).toSearchQuery();
    }
}

