/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.core;

import io.camunda.search.clients.core.AggregationResult;
import io.camunda.search.clients.core.SearchQueryHit;
import io.camunda.util.ObjectBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public record SearchQueryResponse<T>(long totalHits, boolean hasMoreTotalItems, String scrollId, List<SearchQueryHit<T>> hits, Map<String, AggregationResult> aggregations) {
    public static <T> SearchQueryResponse<T> of(Function<Builder<T>, ObjectBuilder<SearchQueryResponse<T>>> fn) {
        return (SearchQueryResponse)fn.apply(new Builder()).build();
    }

    public static final class Builder<T>
    implements ObjectBuilder<SearchQueryResponse<T>> {
        private long totalHits;
        private boolean hasMoreTotalItems = false;
        private String scrollId;
        private List<SearchQueryHit<T>> hits;
        private Map<String, AggregationResult> aggregations;

        public Builder<T> totalHits(long value) {
            this.totalHits = value;
            return this;
        }

        public Builder<T> totalHits(long value, boolean hasMoreTotalItems) {
            this.totalHits = value;
            this.hasMoreTotalItems = hasMoreTotalItems;
            return this;
        }

        public Builder<T> scrollId(String value) {
            this.scrollId = value;
            return this;
        }

        public Builder<T> hits(List<SearchQueryHit<T>> value) {
            this.hits = value;
            return this;
        }

        public Builder<T> aggregations(Map<String, AggregationResult> aggregations) {
            this.aggregations = aggregations;
            return this;
        }

        public SearchQueryResponse<T> build() {
            return new SearchQueryResponse(this.totalHits, this.hasMoreTotalItems, this.scrollId, Objects.requireNonNullElse(this.hits, Collections.emptyList()), this.aggregations);
        }
    }
}

