/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.core;

import io.camunda.search.clients.aggregator.SearchAggregator;
import io.camunda.search.clients.core.RequestBuilders;
import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.source.SearchSourceConfig;
import io.camunda.search.clients.source.SourceConfigBuilders;
import io.camunda.search.sort.SearchSortOptions;
import io.camunda.search.sort.SortOptionsBuilders;
import io.camunda.util.CollectionUtil;
import io.camunda.util.ObjectBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public record SearchQueryRequest(List<String> index, SearchQuery query, List<SearchAggregator> aggregations, List<SearchSortOptions> sort, Object[] searchAfter, Integer from, Integer size, SearchSourceConfig source) {
    public static SearchQueryRequest of(Function<Builder, ObjectBuilder<SearchQueryRequest>> fn) {
        return RequestBuilders.searchRequest(fn);
    }

    public Builder toBuilder() {
        return new Builder().index(this.index).query(this.query).aggregations(this.aggregations).sort(this.sort).searchAfter(this.searchAfter).from(this.from).size(this.size).source(this.source);
    }

    public static final class Builder
    implements ObjectBuilder<SearchQueryRequest> {
        private List<String> index;
        private SearchQuery query;
        private List<SearchAggregator> aggregations;
        private List<SearchSortOptions> sort;
        private Object[] searchAfter;
        private Integer from;
        private Integer size;
        private SearchSourceConfig source;

        public Builder index(List<String> values) {
            this.index = CollectionUtil.addValuesToList(this.index, values);
            return this;
        }

        public Builder index(String value, String ... values) {
            return this.index(CollectionUtil.collectValues((Object)value, (Object[])values));
        }

        public Builder query(SearchQuery value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<SearchQuery.Builder, ObjectBuilder<SearchQuery>> fn) {
            return this.query(SearchQueryBuilders.query(fn));
        }

        public Builder sort(List<SearchSortOptions> values) {
            this.sort = CollectionUtil.addValuesToList(this.sort, values);
            return this;
        }

        public Builder sort(SearchSortOptions value, SearchSortOptions ... values) {
            return this.sort(CollectionUtil.collectValues((Object)value, (Object[])values));
        }

        public Builder sort(Function<SearchSortOptions.Builder, ObjectBuilder<SearchSortOptions>> fn) {
            return this.sort(SortOptionsBuilders.sort(fn), new SearchSortOptions[0]);
        }

        public Builder searchAfter(Object[] value) {
            this.searchAfter = value;
            return this;
        }

        public Builder size(Integer value) {
            this.size = value;
            return this;
        }

        public Builder from(Integer value) {
            this.from = value;
            return this;
        }

        public Builder source(SearchSourceConfig value) {
            this.source = value;
            return this;
        }

        public Builder aggregations(List<SearchAggregator> values) {
            this.aggregations = CollectionUtil.addValuesToList(this.aggregations, values);
            return this;
        }

        public Builder aggregations(SearchAggregator value, SearchAggregator ... values) {
            return this.aggregations(CollectionUtil.collectValues((Object)value, (Object[])values));
        }

        public Builder source(Function<SearchSourceConfig.Builder, ObjectBuilder<SearchSourceConfig>> fn) {
            return this.source(SourceConfigBuilders.sourceConfig(fn));
        }

        public SearchQueryRequest build() {
            return new SearchQueryRequest(Objects.requireNonNull(this.index, "Expected to create request for index, but given index was null."), this.query, this.aggregations, this.sort, this.searchAfter, this.from, this.size, this.source);
        }
    }
}

