/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.core;

import io.camunda.search.clients.core.RequestBuilders;
import io.camunda.util.ObjectBuilder;
import java.util.Objects;
import java.util.function.Function;

public record SearchIndexRequest<T>(String id, String index, String routing, T document) {
    public static <T> SearchIndexRequest<T> of(Function<Builder<T>, ObjectBuilder<SearchIndexRequest<T>>> fn) {
        return RequestBuilders.indexRequest(fn);
    }

    public static final class Builder<T>
    implements ObjectBuilder<SearchIndexRequest<T>> {
        private String id;
        private String index;
        private String routing;
        private T document;

        public Builder<T> id(String value) {
            this.id = value;
            return this;
        }

        public Builder<T> index(String value) {
            this.index = value;
            return this;
        }

        public Builder<T> routing(String value) {
            this.routing = value;
            return this;
        }

        public Builder<T> document(T value) {
            this.document = value;
            return this;
        }

        public SearchIndexRequest<T> build() {
            return new SearchIndexRequest<T>(this.id, Objects.requireNonNull(this.index, "Expected to create request for index, but given index was null."), this.routing, Objects.requireNonNull(this.document, "Expected to index a document, but given document was null."));
        }
    }
}

