/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.auth;

import io.camunda.search.exception.CamundaSearchException;
import io.camunda.security.auth.SecurityContext;
import io.camunda.security.reader.ResourceAccessChecks;
import io.camunda.security.reader.ResourceAccessController;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceAccessDelegatingController
implements ResourceAccessController {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceAccessDelegatingController.class);
    private final List<ResourceAccessController> controllers;

    public ResourceAccessDelegatingController(List<ResourceAccessController> controllers) {
        this.controllers = controllers;
    }

    public <T> T doGet(SecurityContext securityContext, Function<ResourceAccessChecks, T> resourceChecksApplier) {
        return (T)this.getMatchingController(securityContext).doGet(securityContext, resourceChecksApplier);
    }

    public <T> T doSearch(SecurityContext securityContext, Function<ResourceAccessChecks, T> resourceChecksApplier) {
        return (T)this.getMatchingController(securityContext).doSearch(securityContext, resourceChecksApplier);
    }

    public boolean supports(SecurityContext securityContext) {
        return true;
    }

    protected ResourceAccessController getMatchingController(SecurityContext securityContext) {
        return this.controllers.stream().filter(controller -> controller.supports(securityContext)).findFirst().orElseThrow(() -> {
            LOG.error("Failed to find a matching ResourceAccessController, make sure to set a security context using #withSecurityContext()");
            return new CamundaSearchException("Failed to find a matching ResourceAccessController, make sure to set a security context using #withSecurityContext()");
        });
    }
}

