/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.auth;

import io.camunda.search.exception.CamundaSearchException;
import io.camunda.search.exception.ResourceAccessDeniedException;
import io.camunda.search.exception.TenantAccessDeniedException;
import io.camunda.security.auth.Authorization;
import io.camunda.security.auth.CamundaAuthentication;
import io.camunda.security.auth.SecurityContext;
import io.camunda.security.reader.AuthorizationCheck;
import io.camunda.security.reader.ResourceAccess;
import io.camunda.security.reader.ResourceAccessChecks;
import io.camunda.security.reader.ResourceAccessController;
import io.camunda.security.reader.ResourceAccessProvider;
import io.camunda.security.reader.TenantAccess;
import io.camunda.security.reader.TenantAccessProvider;
import io.camunda.security.reader.TenantCheck;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class DocumentBasedResourceAccessController
implements ResourceAccessController {
    private final ResourceAccessProvider resourceAccessProvider;
    private final TenantAccessProvider tenantAccessProvider;

    public DocumentBasedResourceAccessController(ResourceAccessProvider resourceAccessProvider, TenantAccessProvider tenantAccessProvider) {
        this.resourceAccessProvider = resourceAccessProvider;
        this.tenantAccessProvider = tenantAccessProvider;
    }

    public <T> T doGet(SecurityContext securityContext, Function<ResourceAccessChecks, T> resourceChecksApplier) {
        CamundaAuthentication authentication = securityContext.authentication();
        Authorization authorization = securityContext.authorization();
        return this.doPostFiltering(authentication, authorization, resourceChecksApplier);
    }

    public <T> T doSearch(SecurityContext securityContext, Function<ResourceAccessChecks, T> resourceChecksApplier) {
        CamundaAuthentication authentication = securityContext.authentication();
        Authorization authorization = securityContext.authorization();
        return this.doPreFiltering(authentication, authorization, resourceChecksApplier);
    }

    public boolean supports(SecurityContext securityContext) {
        return Optional.of(securityContext).filter(c -> c.authentication() != null && c.authorization() != null).isPresent() && !this.isAnonymousAuthentication(securityContext.authentication());
    }

    protected <T> T doPreFiltering(CamundaAuthentication authentication, Authorization<?> authorization, Function<ResourceAccessChecks, T> applier) {
        AuthorizationCheck authorizationCheck = this.determineAuthorizationCheck(authentication, authorization);
        TenantCheck tenantCheck = this.determineTenantCheck(authentication);
        ResourceAccessChecks resourceAccessChecks = ResourceAccessChecks.of((AuthorizationCheck)authorizationCheck, (TenantCheck)tenantCheck);
        return applier.apply(resourceAccessChecks);
    }

    protected AuthorizationCheck determineAuthorizationCheck(CamundaAuthentication authentication, Authorization<?> authorization) {
        ResourceAccess resourceAccess = this.resolveResourcesAccess(authentication, authorization);
        return this.createAuthorizationCheck(resourceAccess);
    }

    protected ResourceAccess resolveResourcesAccess(CamundaAuthentication authentication, Authorization<?> authorization) {
        return this.resourceAccessProvider.resolveResourceAccess(authentication, authorization);
    }

    protected AuthorizationCheck createAuthorizationCheck(ResourceAccess resourceAccess) {
        return Optional.of(resourceAccess).filter(f -> !f.wildcard()).map(r -> Optional.ofNullable(r.authorization()).map(AuthorizationCheck::enabled).orElseThrow(() -> new CamundaSearchException("Resource Access %s does not include an authorization".formatted(resourceAccess)))).orElseGet(AuthorizationCheck::disabled);
    }

    protected TenantCheck determineTenantCheck(CamundaAuthentication authentication) {
        TenantAccess resourceAccess = this.resolveTenantAccess(authentication);
        return this.createTenantCheck(resourceAccess);
    }

    protected TenantAccess resolveTenantAccess(CamundaAuthentication authentication) {
        return this.tenantAccessProvider.resolveTenantAccess(authentication);
    }

    protected TenantCheck createTenantCheck(TenantAccess tenantAccess) {
        return Optional.of(tenantAccess).filter(t -> !t.wildcard()).map(a -> TenantCheck.enabled((List)tenantAccess.tenantIds())).orElseGet(TenantCheck::disabled);
    }

    protected <T> T doPostFiltering(CamundaAuthentication authentication, Authorization<T> authorization, Function<ResourceAccessChecks, T> applier) {
        T resource = applier.apply(ResourceAccessChecks.disabled());
        if (resource == null) {
            return null;
        }
        this.ensureTenantAccessOrThrow(authentication, resource);
        this.ensureResourceAccessOrThrow(authentication, authorization, resource);
        return resource;
    }

    protected <T> void ensureResourceAccessOrThrow(CamundaAuthentication authentication, Authorization<T> authorization, T document) {
        ResourceAccess resourceAccess = this.resourceAccessProvider.hasResourceAccess(authentication, authorization, document);
        if (resourceAccess.denied()) {
            throw new ResourceAccessDeniedException(authorization);
        }
    }

    protected <T> void ensureTenantAccessOrThrow(CamundaAuthentication authentication, T document) {
        TenantAccess tenantAccess = this.tenantAccessProvider.hasTenantAccess(authentication, document);
        if (tenantAccess.denied()) {
            throw new TenantAccessDeniedException("Tenant access was denied");
        }
    }
}

