/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.auth;

import io.camunda.search.entities.TenantOwnedEntity;
import io.camunda.security.auth.CamundaAuthentication;
import io.camunda.security.reader.TenantAccess;
import io.camunda.security.reader.TenantAccessProvider;
import java.util.List;

public class DefaultTenantAccessProvider
implements TenantAccessProvider {
    public TenantAccess resolveTenantAccess(CamundaAuthentication authentication) {
        List authenticatedTenantIds = authentication.authenticatedTenantIds();
        if (authenticatedTenantIds == null || authenticatedTenantIds.isEmpty()) {
            return TenantAccess.denied(null);
        }
        return TenantAccess.allowed((List)authenticatedTenantIds);
    }

    public <T> TenantAccess hasTenantAccess(CamundaAuthentication authentication, T resource) {
        if (resource instanceof TenantOwnedEntity) {
            TenantOwnedEntity tenantOwnedEntity = (TenantOwnedEntity)resource;
            return this.hasTenantAccessByTenantId(authentication, tenantOwnedEntity.tenantId());
        }
        return TenantAccess.allowed(List.of());
    }

    public TenantAccess hasTenantAccessByTenantId(CamundaAuthentication authentication, String tenantId) {
        List authenticatedTenantIds = authentication.authenticatedTenantIds();
        List<String> tenantIdAsList = List.of(tenantId);
        if (authenticatedTenantIds == null || authenticatedTenantIds.isEmpty()) {
            return TenantAccess.denied(tenantIdAsList);
        }
        return authenticatedTenantIds.contains(tenantId) ? TenantAccess.allowed(tenantIdAsList) : TenantAccess.denied(tenantIdAsList);
    }
}

