/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.aggregator;

import io.camunda.search.clients.aggregator.SearchAggregator;
import io.camunda.util.ObjectBuilder;
import java.util.List;
import java.util.Objects;

public record SearchCompositeAggregator(String name, Integer size, String after, List<SearchAggregator> aggregations, List<SearchAggregator> sources) implements SearchAggregator
{
    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<SearchAggregator> getAggregations() {
        return this.aggregations;
    }

    public static final class Builder
    extends SearchAggregator.AbstractBuilder<Builder>
    implements ObjectBuilder<SearchCompositeAggregator> {
        private Integer size = 10000;
        private String after;
        private List<SearchAggregator> sources;

        @Override
        protected Builder self() {
            return this;
        }

        public Builder size(Integer value) {
            if (value != null && value < 0) {
                throw new IllegalArgumentException("Size must be a positive integer.");
            }
            this.size = value;
            return this;
        }

        public Builder after(String value) {
            this.after = value;
            return this;
        }

        public Builder sources(List<SearchAggregator> sources) {
            this.sources = sources;
            return this;
        }

        public SearchCompositeAggregator build() {
            return new SearchCompositeAggregator(Objects.requireNonNull(this.name, "Expected non-null field for name."), this.size, this.after, this.aggregations, Objects.requireNonNull(this.sources, "Expected non-null field for sources."));
        }
    }
}

