/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients;

import io.camunda.search.aggregation.result.AggregationResultBase;
import io.camunda.search.clients.DocumentBasedSearchClient;
import io.camunda.search.clients.core.SearchGetRequest;
import io.camunda.search.clients.core.SearchGetResponse;
import io.camunda.search.clients.core.SearchQueryRequest;
import io.camunda.search.clients.core.SearchQueryResponse;
import io.camunda.search.clients.source.SearchSourceConfig;
import io.camunda.search.clients.source.SearchSourceFilter;
import io.camunda.search.clients.transformers.ServiceTransformer;
import io.camunda.search.clients.transformers.ServiceTransformers;
import io.camunda.search.clients.transformers.query.SearchQueryResultTransformer;
import io.camunda.search.clients.transformers.query.TypedSearchQueryTransformer;
import io.camunda.search.clients.transformers.result.ResultConfigTransformer;
import io.camunda.search.exception.CamundaSearchException;
import io.camunda.search.filter.FilterBase;
import io.camunda.search.page.SearchQueryPage;
import io.camunda.search.query.SearchQueryResult;
import io.camunda.search.query.TypedSearchQuery;
import io.camunda.search.result.QueryResultConfig;
import io.camunda.search.sort.SortOption;
import io.camunda.security.reader.ResourceAccessChecks;
import io.camunda.zeebe.util.CloseableSilently;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public final class SearchClientBasedQueryExecutor
implements CloseableSilently {
    private final DocumentBasedSearchClient searchClient;
    private final ServiceTransformers transformers;

    public SearchClientBasedQueryExecutor(DocumentBasedSearchClient searchClient, ServiceTransformers transformers) {
        this.searchClient = searchClient;
        this.transformers = transformers;
    }

    public <F extends FilterBase, S extends SortOption, T, R> SearchQueryResult<R> search(TypedSearchQuery<F, S> query, Class<T> documentClass, ResourceAccessChecks resourceAccessChecks) {
        SearchQueryResponse<T> response;
        boolean reverse;
        SearchQueryResultTransformer<T, T> responseTransformer = this.getSearchResultTransformer(documentClass);
        SearchQueryPage.SearchQueryResultType type = query.page().resultType();
        if (type != SearchQueryPage.SearchQueryResultType.UNLIMITED) {
            reverse = !query.page().isNextPage();
            response = this.executePaginatedSearch(query, documentClass, resourceAccessChecks);
        } else {
            reverse = false;
            response = this.executeUnlimitedSearch(query, documentClass, resourceAccessChecks);
        }
        return responseTransformer.apply(response, reverse);
    }

    public <F extends FilterBase, S extends SortOption, R extends AggregationResultBase> R aggregate(TypedSearchQuery<F, S> query, Class<R> resultClass, ResourceAccessChecks resourceAccessChecks) {
        SearchQueryResponse searchQueryResponse = this.executeSearch(query, searchRequest -> this.searchClient.search((SearchQueryRequest)searchRequest, Object.class), resourceAccessChecks);
        return (R)((AggregationResultBase)this.transformers.getSearchAggregationResultTransformer(resultClass).apply(searchQueryResponse.aggregations()));
    }

    public <T, R> R getById(String id, Class<T> documentClass, String index) {
        return this.getById(id, documentClass, index, null);
    }

    public <T, R> R getById(String id, Class<T> documentClass, String index, QueryResultConfig config) {
        SearchGetRequest.Builder builder = new SearchGetRequest.Builder().id(id).index(index);
        Optional.ofNullable(config).map(c -> this.getResultConfigTransformer(config.getClass())).map(t -> (SearchSourceConfig)t.apply(config)).map(SearchSourceConfig::sourceFilter).map(SearchSourceFilter::excludes).ifPresent(builder::sourceExcludes);
        SearchGetRequest getRequest = builder.build();
        SearchGetResponse<T> getResponse = this.searchClient.get(getRequest, documentClass);
        ServiceTransformer<T, T> transformer = this.getDocumentTransformer(documentClass);
        return Optional.ofNullable(getResponse).filter(SearchGetResponse::found).map(SearchGetResponse::source).map(transformer::apply).orElse(null);
    }

    public <F extends FilterBase, S extends SortOption, T, R> R getByQuery(TypedSearchQuery<F, S> query, Class<T> documentClass) {
        return this.getSingleDocumentOrThrowIfNotUnique(() -> this.search(query, documentClass, ResourceAccessChecks.disabled()));
    }

    private <R> R getSingleDocumentOrThrowIfNotUnique(Supplier<SearchQueryResult<R>> resultSupplier) {
        SearchQueryResult<R> searchResult = resultSupplier.get();
        if (searchResult.items().size() > 1) {
            throw new CamundaSearchException("Failed to get entity by a search request, the search query returned more than one result");
        }
        return searchResult.items().stream().findFirst().orElse(null);
    }

    <F extends FilterBase, S extends SortOption, T> SearchQueryResponse<T> executePaginatedSearch(TypedSearchQuery<F, S> query, Class<T> documentClass, ResourceAccessChecks resourceAccessChecks) {
        return this.executeSearch(query, q -> this.searchClient.search((SearchQueryRequest)q, documentClass), resourceAccessChecks);
    }

    <F extends FilterBase, S extends SortOption, T> SearchQueryResponse<T> executeUnlimitedSearch(TypedSearchQuery<F, S> query, Class<T> documentClass, ResourceAccessChecks resourceAccessChecks) {
        return this.executeSearch(query, q -> this.searchClient.scroll((SearchQueryRequest)q, documentClass), resourceAccessChecks);
    }

    <T extends FilterBase, S extends SortOption, R> R executeSearch(TypedSearchQuery<T, S> query, Function<SearchQueryRequest, R> searchExecutor, ResourceAccessChecks resourceAccessChecks) {
        TypedSearchQueryTransformer<T, S> transformer = this.getSearchQueryRequestTransformer(query);
        SearchQueryRequest searchRequest = transformer.apply(query, resourceAccessChecks);
        return searchExecutor.apply(searchRequest);
    }

    private <T extends FilterBase, S extends SortOption> TypedSearchQueryTransformer<T, S> getSearchQueryRequestTransformer(TypedSearchQuery<T, S> query) {
        return this.transformers.getTypedSearchQueryTransformer(query.getClass());
    }

    private <T, R> SearchQueryResultTransformer<T, R> getSearchResultTransformer(Class<R> documentClass) {
        return new SearchQueryResultTransformer<T, R>(this.getDocumentTransformer(documentClass));
    }

    private <T, R> ServiceTransformer<T, R> getDocumentTransformer(Class<R> documentClass) {
        return this.transformers.getTransformer(documentClass);
    }

    private <T extends QueryResultConfig> ResultConfigTransformer<QueryResultConfig> getResultConfigTransformer(Class<T> clazz) {
        ServiceTransformer transformer = this.transformers.getTransformer(clazz);
        return (ResultConfigTransformer)transformer;
    }

    public void close() {
        this.searchClient.close();
    }
}

