/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.es.transformers.search;

import co.elastic.clients.elasticsearch._types.Result;
import co.elastic.clients.elasticsearch._types.WriteResponseBase;
import io.camunda.search.clients.core.SearchWriteResponse;
import io.camunda.search.es.transformers.ElasticsearchTransformer;
import io.camunda.search.es.transformers.ElasticsearchTransformers;

public class SearchWriteResponseTransformer
extends ElasticsearchTransformer<WriteResponseBase, SearchWriteResponse> {
    public SearchWriteResponseTransformer(ElasticsearchTransformers transformers) {
        super(transformers);
    }

    public SearchWriteResponse apply(WriteResponseBase value) {
        String id = value.id();
        String index = value.index();
        SearchWriteResponse.Result result = this.toSearchWriteResult(value.result());
        return SearchWriteResponse.of(b -> b.id(id).index(index).result(result));
    }

    private SearchWriteResponse.Result toSearchWriteResult(Result result) {
        return switch (result) {
            case Result.Created -> SearchWriteResponse.Result.CREATED;
            case Result.Updated -> SearchWriteResponse.Result.UPDATED;
            case Result.Deleted -> SearchWriteResponse.Result.DELETED;
            case Result.NotFound -> SearchWriteResponse.Result.NOT_FOUND;
            default -> SearchWriteResponse.Result.NOOP;
        };
    }
}

