/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.es.transformers.search;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import co.elastic.clients.elasticsearch.core.search.TotalHits;
import co.elastic.clients.elasticsearch.core.search.TotalHitsRelation;
import io.camunda.search.clients.aggregator.SearchAggregator;
import io.camunda.search.clients.core.AggregationResult;
import io.camunda.search.clients.core.SearchQueryHit;
import io.camunda.search.clients.core.SearchQueryResponse;
import io.camunda.search.es.transformers.ElasticsearchTransformer;
import io.camunda.search.es.transformers.ElasticsearchTransformers;
import io.camunda.search.es.transformers.aggregator.SearchAggregationResultTransformer;
import io.camunda.search.es.transformers.search.SearchQueryHitTransformer;
import io.camunda.zeebe.util.collection.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class SearchResponseTransformer<T>
extends ElasticsearchTransformer<Tuple<SearchResponse<T>, List<SearchAggregator>>, SearchQueryResponse<T>> {
    public SearchResponseTransformer(ElasticsearchTransformers transformers) {
        super(transformers);
    }

    public SearchQueryResponse<T> apply(Tuple<SearchResponse<T>, List<SearchAggregator>> tuple) {
        SearchResponse value = (SearchResponse)tuple.getLeft();
        List aggregators = (List)tuple.getRight();
        HitsMetadata hits = value.hits();
        String scrollId = value.scrollId();
        Map responseAggregations = value.aggregations();
        TotalHits total = hits.total();
        long totalHits = this.of(total);
        boolean hasMoreTotalItems = Objects.nonNull(total) && total.relation() == TotalHitsRelation.Gte;
        List sourceHits = hits.hits();
        List<SearchQueryHit<T>> transformedHits = this.of(sourceHits);
        Map<String, AggregationResult> transformedAggregations = this.of(responseAggregations, aggregators);
        return new SearchQueryResponse.Builder().totalHits(totalHits, hasMoreTotalItems).scrollId(scrollId).hits(transformedHits).aggregations(transformedAggregations).build();
    }

    private List<SearchQueryHit<T>> of(List<Hit<T>> hits) {
        if (hits != null) {
            SearchQueryHitTransformer hitTransformer = new SearchQueryHitTransformer(this.transformers);
            return hits.stream().map(hitTransformer::apply).collect(Collectors.toList());
        }
        return new ArrayList<SearchQueryHit<T>>();
    }

    private Map<String, AggregationResult> of(Map<String, Aggregate> value, List<SearchAggregator> aggregators) {
        if (value != null) {
            return new SearchAggregationResultTransformer(this.transformers, aggregators).apply(value);
        }
        return null;
    }

    private long of(TotalHits totalHits) {
        if (totalHits != null) {
            return totalHits.value();
        }
        return 0L;
    }
}

