/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.es.transformers.aggregator;

import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import io.camunda.search.clients.aggregator.SearchAggregator;
import io.camunda.search.clients.aggregator.SearchTopHitsAggregator;
import io.camunda.search.es.transformers.ElasticsearchTransformers;
import io.camunda.search.es.transformers.aggregator.AggregatorTransformer;

public class SearchTopHitsAggregatorTransformer
extends AggregatorTransformer<SearchTopHitsAggregator, Aggregation> {
    public SearchTopHitsAggregatorTransformer(ElasticsearchTransformers transformers) {
        super(transformers);
    }

    public Aggregation apply(SearchTopHitsAggregator value) {
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().topHits(topHitsAggBuilder -> {
            topHitsAggBuilder.size(value.size()).sort(sortBuilder -> {
                sortBuilder.field(fieldSort -> {
                    fieldSort.field(value.field());
                    fieldSort.order(SortOrder.Desc);
                    return fieldSort;
                });
                return sortBuilder;
            });
            return topHitsAggBuilder;
        });
        this.applySubAggregations(builder, (SearchAggregator)value);
        return builder.build();
    }
}

