/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.es.transformers.aggregator;

import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationBuilders;
import co.elastic.clients.elasticsearch._types.aggregations.TermsAggregation;
import co.elastic.clients.util.NamedValue;
import io.camunda.search.clients.aggregator.SearchAggregator;
import io.camunda.search.clients.aggregator.SearchTermsAggregator;
import io.camunda.search.es.transformers.ElasticsearchTransformers;
import io.camunda.search.es.transformers.aggregator.AggregatorTransformer;
import io.camunda.search.sort.SortOption;
import java.util.List;
import java.util.Optional;

public final class SearchTermsAggregatorTransformer
extends AggregatorTransformer<SearchTermsAggregator, Aggregation> {
    public SearchTermsAggregatorTransformer(ElasticsearchTransformers transformers) {
        super(transformers);
    }

    public Aggregation apply(SearchTermsAggregator value) {
        TermsAggregation.Builder termsAggregation = AggregationBuilders.terms().field(value.field()).size(value.size()).minDocCount(value.minDocCount());
        Optional.ofNullable(value.sorting()).ifPresent(sorting -> termsAggregation.order(this.toOrder((List<SortOption.FieldSorting>)sorting)));
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().terms(termsAggregation.build());
        this.applySubAggregations(builder, (SearchAggregator)value);
        return builder.build();
    }

    private List<NamedValue<SortOrder>> toOrder(List<SortOption.FieldSorting> sorting) {
        return sorting.stream().map(fieldSorting -> new NamedValue(fieldSorting.field(), (Object)(fieldSorting.order() == null ? SortOrder.Asc : this.toSortOrder(fieldSorting.order())))).toList();
    }

    private SortOrder toSortOrder(io.camunda.search.sort.SortOrder order) {
        return order == io.camunda.search.sort.SortOrder.ASC ? SortOrder.Asc : SortOrder.Desc;
    }
}

