/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.es.transformers.aggregator;

import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregationSource;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeTermsAggregation;
import co.elastic.clients.util.ObjectBuilder;
import io.camunda.search.clients.aggregator.SearchAggregator;
import io.camunda.search.clients.aggregator.SearchCompositeAggregator;
import io.camunda.search.clients.aggregator.SearchTermsAggregator;
import io.camunda.search.clients.transformers.query.Cursor;
import io.camunda.search.es.transformers.ElasticsearchTransformers;
import io.camunda.search.es.transformers.aggregator.AggregationCursorTransformer;
import io.camunda.search.es.transformers.aggregator.AggregatorTransformer;
import io.camunda.search.sort.SortOption;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class SearchCompositeAggregatorTransformer
extends AggregatorTransformer<SearchCompositeAggregator, Aggregation> {
    private final AggregationCursorTransformer cursorTransformer = new AggregationCursorTransformer();

    public SearchCompositeAggregatorTransformer(ElasticsearchTransformers transformers) {
        super(transformers);
    }

    public Aggregation apply(SearchCompositeAggregator value) {
        CompositeAggregation.Builder compositeAggBuilder = new CompositeAggregation.Builder().size(value.size()).sources(this.toCompositeAggregationSource(value.sources()));
        Object[] after = Cursor.decode((String)value.after());
        if (after != null) {
            compositeAggBuilder.after(this.cursorTransformer.apply(after));
        }
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().composite(compositeAggBuilder.build());
        this.applySubAggregations(builder, (SearchAggregator)value);
        return builder.build();
    }

    private List<Map<String, CompositeAggregationSource>> toCompositeAggregationSource(List<SearchAggregator> aggregators) {
        return aggregators.stream().map(agg -> Map.of(agg.getName(), CompositeAggregationSource.of(sourceBuilder -> {
            SearchAggregator searchAggregator = agg;
            Objects.requireNonNull(searchAggregator);
            SearchAggregator selector0$temp = searchAggregator;
            int index$1 = 0;
            return sourceBuilder.terms(arg_0 -> this.lambda$toCompositeAggregationSource$0(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SearchTermsAggregator.class}, (Object)selector0$temp, index$1)) {
                case 0 -> (SearchTermsAggregator)selector0$temp;
                default -> throw new IllegalStateException("Unsupported aggregator type: " + String.valueOf(agg.getClass()));
            }, arg_0));
        }))).collect(Collectors.toList());
    }

    private CompositeTermsAggregation.Builder buildTerms(SearchTermsAggregator terms, CompositeTermsAggregation.Builder termsBuilder) {
        CompositeTermsAggregation.Builder builder = (CompositeTermsAggregation.Builder)termsBuilder.field(terms.field());
        if (terms.sorting() != null && !terms.sorting().isEmpty()) {
            builder = (CompositeTermsAggregation.Builder)builder.order(this.toSortOrder(terms.field(), terms.sorting()));
        }
        return builder;
    }

    private SortOrder toSortOrder(String termsField, List<SortOption.FieldSorting> sortings) {
        SortOption.FieldSorting sorting = sortings.stream().filter(s -> s.field().equals(termsField)).findFirst().orElseThrow(() -> new IllegalArgumentException("No sorting found for Terms aggregation field: " + termsField + ". Available sortings: " + sortings.stream().map(SortOption.FieldSorting::field).collect(Collectors.joining(", "))));
        return switch (sorting.order()) {
            default -> throw new MatchException(null, null);
            case io.camunda.search.sort.SortOrder.ASC -> SortOrder.Asc;
            case io.camunda.search.sort.SortOrder.DESC -> SortOrder.Desc;
        };
    }

    private /* synthetic */ ObjectBuilder lambda$toCompositeAggregationSource$0(SearchTermsAggregator terms, CompositeTermsAggregation.Builder termsBuilder) {
        return this.buildTerms(terms, termsBuilder);
    }
}

