/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.es.transformers.aggregator;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationBuilders;
import co.elastic.clients.elasticsearch._types.aggregations.BucketSortAggregation;
import io.camunda.search.clients.aggregator.SearchAggregator;
import io.camunda.search.clients.aggregator.SearchBucketSortAggregator;
import io.camunda.search.es.transformers.ElasticsearchTransformers;
import io.camunda.search.es.transformers.aggregator.AggregatorTransformer;
import io.camunda.search.sort.SortOption;
import java.util.List;
import java.util.Optional;

public final class SearchBucketSortAggregationTransformer
extends AggregatorTransformer<SearchBucketSortAggregator, Aggregation> {
    public SearchBucketSortAggregationTransformer(ElasticsearchTransformers transformers) {
        super(transformers);
    }

    public Aggregation apply(SearchBucketSortAggregator value) {
        BucketSortAggregation.Builder bucketSortBuilder = AggregationBuilders.bucketSort();
        Optional.ofNullable(value.sorting()).ifPresent(sorting -> bucketSortBuilder.sort(this.toSort((List<SortOption.FieldSorting>)sorting)));
        Optional.ofNullable(value.from()).ifPresent(arg_0 -> ((BucketSortAggregation.Builder)bucketSortBuilder).from(arg_0));
        Optional.ofNullable(value.size()).ifPresent(arg_0 -> ((BucketSortAggregation.Builder)bucketSortBuilder).size(arg_0));
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().bucketSort(bucketSortBuilder.build());
        this.applySubAggregations(builder, (SearchAggregator)value);
        return builder.build();
    }

    private List<SortOptions> toSort(List<SortOption.FieldSorting> requestedSort) {
        return requestedSort.stream().map(fieldSort -> SortOptions.of(s -> s.field(f -> f.field(fieldSort.field()).order(this.toOrder(fieldSort.order()))))).toList();
    }

    private SortOrder toOrder(io.camunda.search.sort.SortOrder order) {
        return order == io.camunda.search.sort.SortOrder.ASC ? SortOrder.Asc : SortOrder.Desc;
    }
}

