/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.es.transformers.aggregator;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Buckets;
import co.elastic.clients.elasticsearch._types.aggregations.CardinalityAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeBucket;
import co.elastic.clients.elasticsearch._types.aggregations.LongTermsAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.LongTermsBucket;
import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketAggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketBase;
import co.elastic.clients.elasticsearch._types.aggregations.SingleBucketAggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.SingleMetricAggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsBucket;
import co.elastic.clients.elasticsearch._types.aggregations.TermsAggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.TopHitsAggregate;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.json.JsonData;
import io.camunda.search.clients.aggregator.SearchAggregator;
import io.camunda.search.clients.aggregator.SearchTopHitsAggregator;
import io.camunda.search.clients.core.AggregationResult;
import io.camunda.search.clients.core.SearchQueryHit;
import io.camunda.search.clients.transformers.SearchTransfomer;
import io.camunda.search.clients.transformers.query.Cursor;
import io.camunda.search.es.transformers.ElasticsearchTransformers;
import io.camunda.search.es.transformers.search.SearchQueryHitTransformer;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchAggregationResultTransformer<T>
implements SearchTransfomer<Map<String, Aggregate>, Map<String, AggregationResult>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchAggregationResultTransformer.class);
    private static final String COMPOSITE_KEY_DELIMITER = "__";
    private final ElasticsearchTransformers transformers;
    private final List<SearchAggregator> aggregators;

    public SearchAggregationResultTransformer(ElasticsearchTransformers transformers, List<SearchAggregator> aggregators) {
        this.transformers = transformers;
        this.aggregators = aggregators;
    }

    public Map<String, AggregationResult> apply(Map<String, Aggregate> value) {
        return this.transformAggregation(value);
    }

    private AggregationResult transformSingleBucketAggregate(SingleBucketAggregateBase aggregate) {
        return new AggregationResult.Builder().docCount(Long.valueOf(aggregate.docCount())).aggregations(this.transformAggregation(aggregate.aggregations())).build();
    }

    private AggregationResult transformLTermsBucketAggregate(LongTermsAggregate aggregate) {
        return new AggregationResult.Builder().docCount(Long.valueOf(aggregate.buckets().array().size())).build();
    }

    private AggregationResult transformSingleMetricAggregate(SingleMetricAggregateBase aggregate) {
        return new AggregationResult.Builder().docCount(Long.valueOf((long)aggregate.value())).build();
    }

    private SearchTopHitsAggregator findTopHitsAggregatorRecursively(List<SearchAggregator> aggregators, String key) {
        if (aggregators == null || aggregators.isEmpty()) {
            return null;
        }
        Optional<SearchTopHitsAggregator> directMatch = aggregators.stream().filter(SearchTopHitsAggregator.class::isInstance).map(SearchTopHitsAggregator.class::cast).filter(aggregator -> aggregator.getName().equals(key)).findFirst();
        return directMatch.orElseGet(() -> aggregators.stream().map(aggregator -> this.findTopHitsAggregatorRecursively(aggregator.getAggregations(), key)).filter(Objects::nonNull).findFirst().orElse(null));
    }

    private AggregationResult transformTopHitsAggregate(String key, TopHitsAggregate aggregate) {
        List hits = aggregate.hits().hits();
        SearchTopHitsAggregator topHitAggregator = this.findTopHitsAggregatorRecursively(this.aggregators, key);
        return new AggregationResult.Builder().hits(this.toSearchQueryHits(hits, topHitAggregator.documentClass())).build();
    }

    private AggregationResult transformCardinalityAggregate(CardinalityAggregate aggregate) {
        return new AggregationResult.Builder().docCount(Long.valueOf(aggregate.value())).build();
    }

    private <B extends MultiBucketBase> AggregationResult transformMultiBucketAggregate(MultiBucketAggregateBase<B> aggregate) {
        LinkedHashMap map = new LinkedHashMap();
        Buckets buckets = aggregate.buckets();
        Object[] searchAfter = this.extractSearchAfter(aggregate);
        if (buckets.isKeyed()) {
            buckets.keyed().forEach((key, bucket) -> {
                AggregationResult result = new AggregationResult.Builder().docCount(Long.valueOf(bucket.docCount())).aggregations(this.transformAggregation(bucket.aggregations())).build();
                map.put(key, result);
            });
        } else if (buckets.isArray()) {
            List array = buckets.array();
            array.forEach(bucket -> {
                MultiBucketBase multiBucketBase = bucket;
                Objects.requireNonNull(multiBucketBase);
                MultiBucketBase selector0$temp = multiBucketBase;
                int index$1 = 0;
                String key = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StringTermsBucket.class, LongTermsBucket.class, CompositeBucket.class}, (Object)selector0$temp, index$1)) {
                    case 0 -> {
                        StringTermsBucket b = (StringTermsBucket)selector0$temp;
                        yield b.key().stringValue();
                    }
                    case 1 -> {
                        LongTermsBucket b = (LongTermsBucket)selector0$temp;
                        yield b.keyAsString();
                    }
                    case 2 -> {
                        CompositeBucket b = (CompositeBucket)selector0$temp;
                        yield b.key().values().stream().map(FieldValue::stringValue).collect(Collectors.joining(COMPOSITE_KEY_DELIMITER));
                    }
                    default -> throw new IllegalStateException("Unsupported bucket type: " + String.valueOf(bucket.getClass()));
                };
                AggregationResult result = new AggregationResult.Builder().docCount(Long.valueOf(bucket.docCount())).aggregations(this.transformAggregation(bucket.aggregations())).build();
                map.put(key, result);
            });
        }
        return new AggregationResult.Builder().aggregations(map).endCursor(Cursor.encode((Object[])searchAfter)).build();
    }

    private <B extends MultiBucketBase> Object[] extractSearchAfter(MultiBucketAggregateBase<B> aggregate) {
        if (aggregate instanceof CompositeAggregate) {
            CompositeAggregate compositeAggregate = (CompositeAggregate)aggregate;
            return compositeAggregate.afterKey() != null ? compositeAggregate.afterKey().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((FieldValue)entry.getValue()).stringValue())).entrySet().toArray() : null;
        }
        return null;
    }

    private Map<String, AggregationResult> transformAggregation(Map<String, Aggregate> aggregations) {
        if (aggregations.isEmpty()) {
            return null;
        }
        HashMap<String, AggregationResult> result = new HashMap<String, AggregationResult>();
        aggregations.forEach((key, aggregate) -> result.put((String)key, switch (Objects.requireNonNull(aggregate._kind())) {
            case Aggregate.Kind.Children -> this.transformSingleBucketAggregate((SingleBucketAggregateBase)aggregate.children());
            case Aggregate.Kind.Parent -> this.transformSingleBucketAggregate((SingleBucketAggregateBase)aggregate.parent());
            case Aggregate.Kind.Filter -> this.transformSingleBucketAggregate((SingleBucketAggregateBase)aggregate.filter());
            case Aggregate.Kind.Filters -> this.transformMultiBucketAggregate((MultiBucketAggregateBase)aggregate.filters());
            case Aggregate.Kind.Sterms -> this.transformMultiBucketAggregate((MultiBucketAggregateBase)this.warnDocError(aggregate.sterms()));
            case Aggregate.Kind.Lterms -> this.transformLTermsBucketAggregate(this.warnDocError(aggregate.lterms()));
            case Aggregate.Kind.Composite -> this.transformMultiBucketAggregate((MultiBucketAggregateBase)aggregate.composite());
            case Aggregate.Kind.TopHits -> this.transformTopHitsAggregate((String)key, aggregate.topHits());
            case Aggregate.Kind.Sum -> this.transformSingleMetricAggregate((SingleMetricAggregateBase)aggregate.sum());
            case Aggregate.Kind.Cardinality -> this.transformCardinalityAggregate(aggregate.cardinality());
            default -> throw new IllegalStateException("Unsupported aggregation type: " + String.valueOf(aggregate._kind()));
        }));
        return result;
    }

    private <A extends MultiBucketAggregateBase<?>> A warnDocError(A multiBucketAggregate) {
        TermsAggregateBase termsAggregate;
        Long sumOtherDocCount;
        if (multiBucketAggregate instanceof TermsAggregateBase && (sumOtherDocCount = (termsAggregate = (TermsAggregateBase)multiBucketAggregate).sumOtherDocCount()) != null && sumOtherDocCount > 0L) {
            LOGGER.warn("Terms aggregation encountered more buckets ({}) than the specified size.", (Object)sumOtherDocCount);
        }
        return multiBucketAggregate;
    }

    private List<SearchQueryHit> toSearchQueryHits(List<Hit<JsonData>> hits, Class<T> documentClass) {
        if (hits != null) {
            SearchQueryHitTransformer hitTransformer = new SearchQueryHitTransformer(this.transformers);
            return hits.stream().filter(hit -> Objects.nonNull(hit.source())).map(hit -> new Hit.Builder().index(hit.index()).id(hit.id()).score(hit.score()).source(((JsonData)hit.source()).to(documentClass)).build()).map(hitTransformer::apply).collect(Collectors.toList());
        }
        return List.of();
    }
}

