/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.es.clients;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.WriteResponseBase;
import co.elastic.clients.elasticsearch.core.DeleteRequest;
import co.elastic.clients.elasticsearch.core.DeleteResponse;
import co.elastic.clients.elasticsearch.core.GetRequest;
import co.elastic.clients.elasticsearch.core.GetResponse;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.elasticsearch.core.ScrollResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import co.elastic.clients.transport.ElasticsearchTransport;
import io.camunda.search.clients.DocumentBasedSearchClient;
import io.camunda.search.clients.DocumentBasedWriteClient;
import io.camunda.search.clients.core.SearchDeleteRequest;
import io.camunda.search.clients.core.SearchGetRequest;
import io.camunda.search.clients.core.SearchGetResponse;
import io.camunda.search.clients.core.SearchIndexRequest;
import io.camunda.search.clients.core.SearchQueryHit;
import io.camunda.search.clients.core.SearchQueryRequest;
import io.camunda.search.clients.core.SearchQueryResponse;
import io.camunda.search.clients.core.SearchWriteResponse;
import io.camunda.search.clients.transformers.SearchTransfomer;
import io.camunda.search.es.transformers.ElasticsearchTransformers;
import io.camunda.search.es.transformers.search.SearchDeleteRequestTransformer;
import io.camunda.search.es.transformers.search.SearchGetRequestTransformer;
import io.camunda.search.es.transformers.search.SearchGetResponseTransformer;
import io.camunda.search.es.transformers.search.SearchIndexRequestTransformer;
import io.camunda.search.es.transformers.search.SearchQueryHitTransformer;
import io.camunda.search.es.transformers.search.SearchRequestTransformer;
import io.camunda.search.es.transformers.search.SearchResponseTransformer;
import io.camunda.search.es.transformers.search.SearchWriteResponseTransformer;
import io.camunda.search.exception.CamundaSearchException;
import io.camunda.zeebe.util.collection.Tuple;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchSearchClient
implements DocumentBasedSearchClient,
DocumentBasedWriteClient {
    private static final int ELASTICSEARCH_QUERY_MAX_PAGE_SIZE = 10000;
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchSearchClient.class);
    private static final String SCROLL_KEEP_ALIVE_TIME = "1m";
    private final ElasticsearchClient client;
    private final ElasticsearchTransformers transformers;

    public ElasticsearchSearchClient(ElasticsearchClient client) {
        this(client, new ElasticsearchTransformers());
    }

    public ElasticsearchSearchClient(ElasticsearchClient client, ElasticsearchTransformers transformers) {
        this.client = client;
        this.transformers = transformers;
    }

    public <T> SearchQueryResponse<T> search(SearchQueryRequest searchRequest, Class<T> documentClass) {
        try {
            SearchRequestTransformer requestTransformer = this.getSearchRequestTransformer();
            SearchRequest request = requestTransformer.apply(searchRequest);
            SearchResponse rawSearchResponse = this.client.search(request, documentClass);
            SearchResponseTransformer<T> searchResponseTransformer = this.getSearchResponseTransformer();
            return searchResponseTransformer.apply(Tuple.of((Object)rawSearchResponse, (Object)searchRequest.aggregations()));
        }
        catch (ElasticsearchException | IOException e) {
            LOGGER.warn("Failed to execute search query", e);
            throw new CamundaSearchException("Failed to execute search query", e, ElasticsearchSearchClient.searchExceptionToReason((Exception)e));
        }
    }

    public <T> SearchQueryResponse<T> scroll(SearchQueryRequest searchRequest, Class<T> documentClass) {
        String scrollId;
        ArrayList<Hit<T>> totalHits;
        block6: {
            totalHits = new ArrayList<Hit<T>>();
            int queryMaxPageSize = 10000;
            scrollId = null;
            SearchRequest request = this.transformSearchRequestToScrollRequest(searchRequest, 10000);
            SearchResponse rawSearchResponse = this.client.search(request, documentClass);
            scrollId = rawSearchResponse.scrollId();
            List<Hit<T>> searchResponseHits = this.collectHits(rawSearchResponse.hits());
            totalHits.addAll(searchResponseHits);
            if (totalHits.size() >= 10000) break block6;
            SearchResponseTransformer<T> searchResponseTransformer = this.getSearchResponseTransformer();
            SearchQueryResponse<T> searchQueryResponse = searchResponseTransformer.apply(Tuple.of((Object)rawSearchResponse, (Object)searchRequest.aggregations()));
            this.clearScroll(scrollId);
            return searchQueryResponse;
        }
        try {
            List<Hit<T>> scrollResponseHits;
            do {
                ScrollResponse<T> rawScrollResponse = this.scroll(scrollId, documentClass);
                scrollId = rawScrollResponse.scrollId();
                scrollResponseHits = this.collectHits(rawScrollResponse.hits());
                totalHits.addAll(scrollResponseHits);
            } while (!scrollResponseHits.isEmpty() && scrollResponseHits.size() >= 10000);
            SearchQueryResponse<T> searchQueryResponse = this.transformScrollResponseHits(totalHits);
            this.clearScroll(scrollId);
            return searchQueryResponse;
        }
        catch (ElasticsearchException | IOException e) {
            try {
                LOGGER.warn("Failed to execute findAll query", e);
                throw new CamundaSearchException("Failed to execute findAll query", e, ElasticsearchSearchClient.searchExceptionToReason((Exception)e));
            }
            catch (Throwable throwable) {
                this.clearScroll(scrollId);
                throw throwable;
            }
        }
    }

    public <T> SearchGetResponse<T> get(SearchGetRequest getRequest, Class<T> documentClass) {
        try {
            SearchGetRequestTransformer requestTransformer = this.getSearchGetRequestTransformer();
            GetRequest request = requestTransformer.apply(getRequest);
            GetResponse rawGetResponse = this.client.get(request, documentClass);
            SearchGetResponseTransformer<T> getResponseTransformer = this.getSearchGetResponseTransformer();
            return getResponseTransformer.apply(rawGetResponse);
        }
        catch (ElasticsearchException | IOException e) {
            LOGGER.warn("Failed to execute get request", e);
            throw new CamundaSearchException("Failed to execute get request", e, ElasticsearchSearchClient.searchExceptionToReason((Exception)e));
        }
    }

    private SearchRequest transformSearchRequestToScrollRequest(SearchQueryRequest searchRequest, int queryMaxSize) {
        return this.getSearchRequestTransformer().withSearchRequestCustomizer(c -> c.size(Integer.valueOf(queryMaxSize)).scroll(s -> s.time(SCROLL_KEEP_ALIVE_TIME))).apply(searchRequest);
    }

    private <T> List<Hit<T>> collectHits(HitsMetadata<T> hitsMetadata) {
        return hitsMetadata.hits().stream().toList();
    }

    private <T> SearchQueryResponse<T> transformScrollResponseHits(List<Hit<T>> hits) {
        SearchQueryHitTransformer searchQueryHitTransformer = new SearchQueryHitTransformer(this.transformers);
        List<SearchQueryHit> transformedHits = hits.stream().map(searchQueryHitTransformer::apply).toList();
        return new SearchQueryResponse.Builder().totalHits((long)hits.size()).hits(transformedHits).build();
    }

    public <T> SearchWriteResponse index(SearchIndexRequest<T> indexRequest) {
        try {
            SearchIndexRequestTransformer<T> requestTransformer = this.getSearchIndexRequestTransformer();
            IndexRequest<T> request = requestTransformer.apply(indexRequest);
            IndexResponse rawIndexResponse = this.client.index(request);
            SearchWriteResponseTransformer indexResponseTransformer = this.getSearchWriteResponseTransformer();
            return indexResponseTransformer.apply((WriteResponseBase)rawIndexResponse);
        }
        catch (ElasticsearchException | IOException e) {
            LOGGER.warn("Failed to execute index request", e);
            throw new CamundaSearchException("Failed to execute index request", e, ElasticsearchSearchClient.searchExceptionToReason((Exception)e));
        }
    }

    public SearchWriteResponse delete(SearchDeleteRequest deleteRequest) {
        try {
            SearchDeleteRequestTransformer requestTransformer = this.getSearchDeleteRequestTransformer();
            DeleteRequest request = requestTransformer.apply(deleteRequest);
            DeleteResponse rawDeleteRequest = this.client.delete(request);
            SearchWriteResponseTransformer deleteResponseTransformer = this.getSearchWriteResponseTransformer();
            return deleteResponseTransformer.apply((WriteResponseBase)rawDeleteRequest);
        }
        catch (ElasticsearchException | IOException e) {
            LOGGER.warn("Failed to execute delete request", e);
            throw new CamundaSearchException("Failed to execute delete request", e, ElasticsearchSearchClient.searchExceptionToReason((Exception)e));
        }
    }

    private <T> ScrollResponse<T> scroll(String scrollId, Class<T> documentClass) throws IOException {
        return this.client.scroll(r -> r.scrollId(scrollId).scroll(t -> t.time(SCROLL_KEEP_ALIVE_TIME)), documentClass);
    }

    private void clearScroll(String scrollId) {
        if (scrollId != null) {
            try {
                this.client.clearScroll(r -> r.scrollId(scrollId, new String[0]));
            }
            catch (ElasticsearchException | IOException e) {
                LOGGER.warn("Failed to clear scroll.", e);
            }
        }
    }

    private SearchRequestTransformer getSearchRequestTransformer() {
        SearchTransfomer transformer = this.transformers.getTransformer(SearchQueryRequest.class);
        return (SearchRequestTransformer)transformer;
    }

    private <T> SearchResponseTransformer<T> getSearchResponseTransformer() {
        SearchTransfomer transformer = this.transformers.getTransformer(SearchQueryResponse.class);
        return (SearchResponseTransformer)transformer;
    }

    private SearchGetRequestTransformer getSearchGetRequestTransformer() {
        SearchTransfomer transformer = this.transformers.getTransformer(SearchGetRequest.class);
        return (SearchGetRequestTransformer)transformer;
    }

    private <T> SearchGetResponseTransformer<T> getSearchGetResponseTransformer() {
        SearchTransfomer transformer = this.transformers.getTransformer(SearchGetResponse.class);
        return (SearchGetResponseTransformer)transformer;
    }

    private <T> SearchIndexRequestTransformer<T> getSearchIndexRequestTransformer() {
        SearchTransfomer transformer = this.transformers.getTransformer(SearchIndexRequest.class);
        return (SearchIndexRequestTransformer)transformer;
    }

    private SearchDeleteRequestTransformer getSearchDeleteRequestTransformer() {
        SearchTransfomer transformer = this.transformers.getTransformer(SearchDeleteRequest.class);
        return (SearchDeleteRequestTransformer)transformer;
    }

    private SearchWriteResponseTransformer getSearchWriteResponseTransformer() {
        SearchTransfomer transformer = this.transformers.getTransformer(SearchWriteResponse.class);
        return (SearchWriteResponseTransformer)transformer;
    }

    public void close() {
        if (this.client != null) {
            try {
                ((ElasticsearchTransport)this.client._transport()).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static CamundaSearchException.Reason searchExceptionToReason(Exception e) {
        if (e instanceof ConnectException || e instanceof SocketTimeoutException || e.getClass().getSimpleName().equals("ConnectionClosedException")) {
            return CamundaSearchException.Reason.CONNECTION_FAILED;
        }
        if (e instanceof ElasticsearchException) {
            return CamundaSearchException.Reason.SEARCH_SERVER_FAILED;
        }
        return CamundaSearchException.Reason.SEARCH_CLIENT_FAILED;
    }
}

