/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.es.transformers.query;

import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.UntypedRangeQuery;
import co.elastic.clients.json.JsonData;
import io.camunda.search.clients.query.SearchRangeQuery;
import io.camunda.search.es.transformers.ElasticsearchTransformers;
import io.camunda.search.es.transformers.query.QueryOptionTransformer;

public final class RangeQueryTransformer
extends QueryOptionTransformer<SearchRangeQuery, RangeQuery> {
    public RangeQueryTransformer(ElasticsearchTransformers transformers) {
        super(transformers);
    }

    public RangeQuery apply(SearchRangeQuery value) {
        String field = value.field();
        UntypedRangeQuery.Builder untypedBuilder = new UntypedRangeQuery.Builder();
        untypedBuilder.field(field);
        if (value.gt() != null) {
            untypedBuilder.gt((Object)this.of(value.gt()));
        }
        if (value.gte() != null) {
            untypedBuilder.gte((Object)this.of(value.gte()));
        }
        if (value.lt() != null) {
            untypedBuilder.lt((Object)this.of(value.lt()));
        }
        if (value.lte() != null) {
            untypedBuilder.lte((Object)this.of(value.lte()));
        }
        if (value.format() != null) {
            untypedBuilder.format(value.format());
        }
        return (RangeQuery)QueryBuilders.range().untyped(untypedBuilder.build()).build();
    }

    private <T> JsonData of(T value) {
        return JsonData.of(value);
    }
}

