/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.es.transformers.query;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import io.camunda.search.clients.query.SearchBoolQuery;
import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.transformers.SearchTransfomer;
import io.camunda.search.es.transformers.ElasticsearchTransformers;
import io.camunda.search.es.transformers.query.QueryOptionTransformer;
import java.util.List;
import java.util.stream.Collectors;

public final class BoolQueryTransformer
extends QueryOptionTransformer<SearchBoolQuery, BoolQuery> {
    public BoolQueryTransformer(ElasticsearchTransformers transformers) {
        super(transformers);
    }

    public BoolQuery apply(SearchBoolQuery value) {
        BoolQuery.Builder builder = QueryBuilders.bool();
        List filter = value.filter();
        List must = value.must();
        List should = value.should();
        List mustNot = value.mustNot();
        if (filter != null && !filter.isEmpty()) {
            builder.filter(this.of(filter));
        }
        if (must != null && !must.isEmpty()) {
            builder.must(this.of(must));
        }
        if (should != null && !should.isEmpty()) {
            builder.should(this.of(should));
        }
        if (mustNot != null && !mustNot.isEmpty()) {
            builder.mustNot(this.of(mustNot));
        }
        return builder.build();
    }

    private List<Query> of(List<SearchQuery> values) {
        SearchTransfomer<SearchQuery, Query> transformer = this.getQueryTransformer();
        return values.stream().map(arg_0 -> transformer.apply(arg_0)).collect(Collectors.toList());
    }
}

