/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.es.transformers.aggregator;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.Buckets;
import co.elastic.clients.elasticsearch._types.aggregations.FiltersAggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import io.camunda.search.clients.aggregator.SearchAggregator;
import io.camunda.search.clients.aggregator.SearchFiltersAggregator;
import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.es.transformers.ElasticsearchTransformers;
import io.camunda.search.es.transformers.aggregator.AggregatorTransformer;
import java.util.Map;
import java.util.stream.Collectors;

public class SearchFiltersAggregatorTransformer
extends AggregatorTransformer<SearchFiltersAggregator, Aggregation> {
    public SearchFiltersAggregatorTransformer(ElasticsearchTransformers transformers) {
        super(transformers);
    }

    public Aggregation apply(SearchFiltersAggregator value) {
        Map<String, Query> queries = value.queries().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Query)this.getQueryTransformer().apply((Object)((SearchQuery)e.getValue()))));
        FiltersAggregation filterBuckets = new FiltersAggregation.Builder().filters((Buckets)new Buckets.Builder().keyed(queries).build()).build();
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().filters(filterBuckets);
        this.applySubAggregations(builder, (SearchAggregator)value);
        return builder.build();
    }
}

