/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.es.transformers.aggregator;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Buckets;
import co.elastic.clients.elasticsearch._types.aggregations.LongTermsBucket;
import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketAggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketBase;
import co.elastic.clients.elasticsearch._types.aggregations.SingleBucketAggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsBucket;
import io.camunda.search.clients.core.AggregationResult;
import io.camunda.search.clients.transformers.SearchTransfomer;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SearchAggregationResultTransformer
implements SearchTransfomer<Map<String, Aggregate>, Map<String, AggregationResult>> {
    public Map<String, AggregationResult> apply(Map<String, Aggregate> value) {
        return this.transformAggregation(value);
    }

    private AggregationResult transformSingleBucketAggregate(SingleBucketAggregateBase aggregate) {
        return new AggregationResult.Builder().docCount(Long.valueOf(aggregate.docCount())).aggregations(this.transformAggregation(aggregate.aggregations())).build();
    }

    private <B extends MultiBucketBase> AggregationResult transformMultiBucketAggregate(MultiBucketAggregateBase<B> aggregate) {
        HashMap map = new HashMap();
        Buckets buckets = aggregate.buckets();
        if (buckets.isKeyed()) {
            buckets.keyed().forEach((key, bucket) -> {
                AggregationResult result = new AggregationResult.Builder().docCount(Long.valueOf(bucket.docCount())).aggregations(this.transformAggregation(bucket.aggregations())).build();
                map.put(key, result);
            });
        } else if (buckets.isArray()) {
            List array = buckets.array();
            array.forEach(bucket -> {
                MultiBucketBase multiBucketBase = bucket;
                Objects.requireNonNull(multiBucketBase);
                MultiBucketBase selector0$temp = multiBucketBase;
                int index$1 = 0;
                String key = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StringTermsBucket.class, LongTermsBucket.class}, (Object)selector0$temp, index$1)) {
                    case 0 -> {
                        StringTermsBucket b = (StringTermsBucket)selector0$temp;
                        yield b.key().stringValue();
                    }
                    case 1 -> {
                        LongTermsBucket b = (LongTermsBucket)selector0$temp;
                        yield b.keyAsString();
                    }
                    default -> throw new IllegalStateException("Unsupported bucket type: " + String.valueOf(bucket.getClass()));
                };
                AggregationResult result = new AggregationResult.Builder().docCount(Long.valueOf(bucket.docCount())).aggregations(this.transformAggregation(bucket.aggregations())).build();
                map.put(key, result);
            });
        }
        return new AggregationResult.Builder().aggregations(map).build();
    }

    private Map<String, AggregationResult> transformAggregation(Map<String, Aggregate> aggregations) {
        if (aggregations.isEmpty()) {
            return null;
        }
        HashMap<String, AggregationResult> result = new HashMap<String, AggregationResult>();
        aggregations.forEach((key, aggregate) -> result.put((String)key, switch (Objects.requireNonNull(aggregate._kind())) {
            case Aggregate.Kind.Children -> this.transformSingleBucketAggregate((SingleBucketAggregateBase)aggregate.children());
            case Aggregate.Kind.Parent -> this.transformSingleBucketAggregate((SingleBucketAggregateBase)aggregate.parent());
            case Aggregate.Kind.Filter -> this.transformSingleBucketAggregate((SingleBucketAggregateBase)aggregate.filter());
            case Aggregate.Kind.Filters -> this.transformMultiBucketAggregate((MultiBucketAggregateBase)aggregate.filters());
            case Aggregate.Kind.Sterms -> this.transformMultiBucketAggregate((MultiBucketAggregateBase)aggregate.sterms());
            default -> throw new IllegalStateException("Unsupported aggregation type: " + String.valueOf(aggregate._kind()));
        }));
        return result;
    }
}

