/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.es.transformers.types;

import co.elastic.clients.elasticsearch._types.FieldValue;
import io.camunda.search.clients.types.TypedValue;
import io.camunda.search.es.transformers.ElasticsearchTransformer;
import io.camunda.search.es.transformers.ElasticsearchTransformers;

public final class TypedValueTransformer
extends ElasticsearchTransformer<TypedValue, FieldValue> {
    public TypedValueTransformer(ElasticsearchTransformers transformers) {
        super(transformers);
    }

    public FieldValue apply(TypedValue value) {
        if (value.isString()) {
            return FieldValue.of((String)value.stringValue());
        }
        if (value.isInteger()) {
            return FieldValue.of((long)value.intValue());
        }
        if (value.isLong()) {
            return FieldValue.of((long)value.longValue());
        }
        if (value.isBoolean()) {
            return FieldValue.of((boolean)value.booleanValue());
        }
        if (value.isDouble()) {
            return FieldValue.of((double)value.doubleValue());
        }
        if (value.isNull()) {
            return FieldValue.NULL;
        }
        throw new IllegalArgumentException("Unsupported type for TypedValue");
    }
}

