/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.es.transformers.query;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsQueryField;
import io.camunda.search.clients.query.SearchTermsQuery;
import io.camunda.search.clients.transformers.SearchTransfomer;
import io.camunda.search.clients.types.TypedValue;
import io.camunda.search.es.transformers.ElasticsearchTransformers;
import io.camunda.search.es.transformers.query.QueryOptionTransformer;
import java.util.List;
import java.util.stream.Collectors;

public final class TermsQueryTransformer
extends QueryOptionTransformer<SearchTermsQuery, TermsQuery> {
    public TermsQueryTransformer(ElasticsearchTransformers transformers) {
        super(transformers);
    }

    public TermsQuery apply(SearchTermsQuery value) {
        String field = value.field();
        List values = value.values();
        TermsQueryField termsQueryField = this.of(values);
        return QueryBuilders.terms().field(field).terms(termsQueryField).build();
    }

    private <T> TermsQueryField of(List<TypedValue> values) {
        SearchTransfomer<TypedValue, FieldValue> transformer = this.getFieldValueTransformer();
        List fieldValues = values.stream().map(arg_0 -> transformer.apply(arg_0)).collect(Collectors.toList());
        return TermsQueryField.of(f -> f.value(fieldValues));
    }
}

