/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.es.transformers.query;

import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQuery;
import co.elastic.clients.json.JsonData;
import io.camunda.search.clients.query.SearchRangeQuery;
import io.camunda.search.es.transformers.ElasticsearchTransformers;
import io.camunda.search.es.transformers.query.QueryOptionTransformer;

public final class RangeQueryTransformer
extends QueryOptionTransformer<SearchRangeQuery, RangeQuery> {
    public RangeQueryTransformer(ElasticsearchTransformers transformers) {
        super(transformers);
    }

    public RangeQuery apply(SearchRangeQuery value) {
        String field = value.field();
        RangeQuery.Builder builder = QueryBuilders.range().field(field);
        if (value.gt() != null) {
            builder.gt(this.of(value.gt()));
        }
        if (value.gte() != null) {
            builder.gte(this.of(value.gte()));
        }
        if (value.lt() != null) {
            builder.lt(this.of(value.lt()));
        }
        if (value.lte() != null) {
            builder.lte(this.of(value.lte()));
        }
        if (value.format() != null) {
            builder.format(value.format());
        }
        return builder.build();
    }

    private <T> JsonData of(T value) {
        return JsonData.of(value);
    }
}

