/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.es.clients;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch.core.ScrollResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.transport.ElasticsearchTransport;
import io.camunda.search.clients.DocumentBasedSearchClient;
import io.camunda.search.clients.core.SearchQueryRequest;
import io.camunda.search.clients.core.SearchQueryResponse;
import io.camunda.search.clients.transformers.SearchTransfomer;
import io.camunda.search.es.transformers.ElasticsearchTransformers;
import io.camunda.search.es.transformers.search.SearchRequestTransformer;
import io.camunda.search.es.transformers.search.SearchResponseTransformer;
import io.camunda.search.exception.SearchQueryExecutionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchSearchClient
implements DocumentBasedSearchClient,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchSearchClient.class);
    private static final String SCROLL_KEEP_ALIVE_TIME = "1m";
    private final ElasticsearchClient client;
    private final ElasticsearchTransformers transformers;

    public ElasticsearchSearchClient(ElasticsearchClient client) {
        this(client, new ElasticsearchTransformers());
    }

    public ElasticsearchSearchClient(ElasticsearchClient client, ElasticsearchTransformers transformers) {
        this.client = client;
        this.transformers = transformers;
    }

    public <T> SearchQueryResponse<T> search(SearchQueryRequest searchRequest, Class<T> documentClass) {
        try {
            SearchRequestTransformer requestTransformer = this.getSearchRequestTransformer();
            SearchRequest request = requestTransformer.apply(searchRequest);
            SearchResponse rawSearchResponse = this.client.search(request, documentClass);
            SearchResponseTransformer<T> searchResponseTransformer = this.getSearchResponseTransformer();
            return searchResponseTransformer.apply(rawSearchResponse);
        }
        catch (ElasticsearchException | IOException ioe) {
            throw new SearchQueryExecutionException("Failed to execute search query", ioe);
        }
    }

    public <T> List<T> findAll(SearchQueryRequest searchRequest, Class<T> documentClass) {
        ArrayList<Object> result = new ArrayList<Object>();
        String scrollId = null;
        try {
            SearchRequest request = this.getSearchRequestTransformer().toSearchRequestBuilder(searchRequest).scroll(s -> s.time(SCROLL_KEEP_ALIVE_TIME)).build();
            SearchResponse rawSearchResponse = this.client.search(request, documentClass);
            scrollId = rawSearchResponse.scrollId();
            List<Object> items = rawSearchResponse.hits().hits().stream().map(Hit::source).toList();
            result.addAll(items);
            int pageSize = Optional.ofNullable(searchRequest.size()).orElse(items.size());
            while (!items.isEmpty() && items.size() == pageSize) {
                ScrollResponse<T> scrollResponse = this.scroll(scrollId, documentClass);
                scrollId = scrollResponse.scrollId();
                items = scrollResponse.hits().hits().stream().map(Hit::source).toList();
                result.addAll(items);
            }
            this.clearScroll(scrollId);
        }
        catch (ElasticsearchException | IOException e) {
            try {
                throw new SearchQueryExecutionException("Failed to execute findAll query", e);
            }
            catch (Throwable throwable) {
                this.clearScroll(scrollId);
                throw throwable;
            }
        }
        return result;
    }

    private <T> ScrollResponse<T> scroll(String scrollId, Class<T> documentClass) throws IOException {
        return this.client.scroll(r -> r.scrollId(scrollId), documentClass);
    }

    private void clearScroll(String scrollId) {
        if (scrollId != null) {
            try {
                this.client.clearScroll(r -> r.scrollId(scrollId, new String[0]));
            }
            catch (ElasticsearchException | IOException e) {
                LOGGER.error("Failed to clear scroll.", e);
            }
        }
    }

    private SearchRequestTransformer getSearchRequestTransformer() {
        SearchTransfomer transformer = this.transformers.getTransformer(SearchQueryRequest.class);
        return (SearchRequestTransformer)transformer;
    }

    private <T> SearchResponseTransformer<T> getSearchResponseTransformer() {
        SearchTransfomer transformer = this.transformers.getTransformer(SearchQueryResponse.class);
        return (SearchResponseTransformer)transformer;
    }

    @Override
    public void close() throws Exception {
        if (this.client != null) {
            try {
                ((ElasticsearchTransport)this.client._transport()).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

