/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.es.clients;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.transport.ElasticsearchTransport;
import io.camunda.search.clients.DocumentBasedSearchClient;
import io.camunda.search.clients.core.SearchQueryRequest;
import io.camunda.search.clients.core.SearchQueryResponse;
import io.camunda.search.clients.transformers.SearchTransfomer;
import io.camunda.search.es.transformers.ElasticsearchTransformers;
import io.camunda.search.es.transformers.search.SearchResponseTransformer;
import io.camunda.search.exception.SearchQueryExecutionException;
import java.io.IOException;

public class ElasticsearchSearchClient
implements DocumentBasedSearchClient,
AutoCloseable {
    private final ElasticsearchClient client;
    private final ElasticsearchTransformers transformers;

    public ElasticsearchSearchClient(ElasticsearchClient client) {
        this(client, new ElasticsearchTransformers());
    }

    public ElasticsearchSearchClient(ElasticsearchClient client, ElasticsearchTransformers transformers) {
        this.client = client;
        this.transformers = transformers;
    }

    public <T> SearchQueryResponse<T> search(SearchQueryRequest searchRequest, Class<T> documentClass) {
        try {
            SearchTransfomer<SearchQueryRequest, SearchRequest> requestTransformer = this.getSearchRequestTransformer();
            SearchRequest request = (SearchRequest)requestTransformer.apply((Object)searchRequest);
            SearchResponse rawSearchResponse = this.client.search(request, documentClass);
            SearchResponseTransformer<T> searchResponseTransformer = this.getSearchResponseTransformer();
            return searchResponseTransformer.apply(rawSearchResponse);
        }
        catch (ElasticsearchException | IOException ioe) {
            throw new SearchQueryExecutionException("Failed to execute search query", ioe);
        }
    }

    protected SearchTransfomer<SearchQueryRequest, SearchRequest> getSearchRequestTransformer() {
        return this.transformers.getTransformer(SearchQueryRequest.class);
    }

    private <T> SearchResponseTransformer<T> getSearchResponseTransformer() {
        return new SearchResponseTransformer(this.transformers);
    }

    @Override
    public void close() throws Exception {
        if (this.client != null) {
            try {
                ((ElasticsearchTransport)this.client._transport()).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

