/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.es.transformers.query;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.query_dsl.MatchQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Operator;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import io.camunda.search.clients.query.SearchMatchQuery;
import io.camunda.search.es.transformers.ElasticsearchTransformers;
import io.camunda.search.es.transformers.query.QueryOptionTransformer;

public final class MatchQueryTransformer
extends QueryOptionTransformer<SearchMatchQuery, MatchQuery> {
    public MatchQueryTransformer(ElasticsearchTransformers transformers) {
        super(transformers);
    }

    public MatchQuery apply(SearchMatchQuery value) {
        String field = value.field();
        String query = value.query();
        FieldValue queryAsFieldValue = FieldValue.of((String)query);
        SearchMatchQuery.SearchMatchQueryOperator operator = value.operator();
        MatchQuery.Builder builder = QueryBuilders.match().field(field).query(queryAsFieldValue);
        if (operator != null) {
            switch (operator) {
                case AND: {
                    builder.operator(Operator.And);
                    break;
                }
                case OR: {
                    builder.operator(Operator.Or);
                    break;
                }
            }
        }
        return builder.build();
    }
}

