/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.es.transformers.search;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.json.JsonData;
import io.camunda.search.clients.core.SearchQueryRequest;
import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.sort.SearchSortOptions;
import io.camunda.search.es.transformers.ElasticsearchTransformer;
import io.camunda.search.es.transformers.ElasticsearchTransformers;
import io.camunda.search.transformers.SearchTransfomer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class SearchRequestTransformer
extends ElasticsearchTransformer<SearchQueryRequest, SearchRequest> {
    public SearchRequestTransformer(ElasticsearchTransformers transformers) {
        super(transformers);
    }

    public SearchRequest apply(SearchQueryRequest value) {
        List sort = value.sort();
        Object[] searchAfter = value.searchAfter();
        SearchQuery searchQuery = value.query();
        SearchRequest.Builder builder = new SearchRequest.Builder().index(value.index()).from(value.from()).size(value.size());
        if (searchQuery != null) {
            SearchTransfomer<SearchQuery, Query> queryTransformer = this.getQueryTransformer();
            Query transformedQuery = (Query)queryTransformer.apply((Object)searchQuery);
            builder.query(transformedQuery);
        }
        if (sort != null && !sort.isEmpty()) {
            builder.sort(this.of(sort));
        }
        if (searchAfter != null && searchAfter.length > 0) {
            builder.searchAfter(this.of(searchAfter));
        }
        return builder.build();
    }

    private List<SortOptions> of(List<SearchSortOptions> values) {
        SearchTransfomer<SearchSortOptions, SortOptions> sortTransformer = this.getSortOptionsTransformer();
        return values.stream().map(arg_0 -> sortTransformer.apply(arg_0)).collect(Collectors.toList());
    }

    private List<FieldValue> of(Object[] values) {
        return Arrays.asList(values).stream().map(JsonData::of).map(FieldValue::of).collect(Collectors.toList());
    }
}

