/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.connect.plugin;

import io.camunda.plugin.search.header.CustomHeader;
import io.camunda.plugin.search.header.DatabaseCustomHeaderSupplier;
import io.camunda.search.connect.plugin.CompatHttpRequestInterceptor;
import io.camunda.search.connect.plugin.PluginRepository;
import java.util.List;
import java.util.SequencedCollection;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.http.HttpRequest;

final class PluginRepositoryInterceptor
implements CompatHttpRequestInterceptor {
    private final SequencedCollection<DatabaseCustomHeaderSupplier> databaseHeaderPlugins;

    PluginRepositoryInterceptor(SequencedCollection<DatabaseCustomHeaderSupplier> plugins) {
        this.databaseHeaderPlugins = plugins;
    }

    static PluginRepositoryInterceptor ofRepository(PluginRepository repository) {
        List<DatabaseCustomHeaderSupplier> interceptors = repository.instantiatePlugins().toList();
        return new PluginRepositoryInterceptor(interceptors);
    }

    public void process(org.apache.hc.core5.http.HttpRequest request, EntityDetails entity, HttpContext context) {
        for (DatabaseCustomHeaderSupplier plugin : this.databaseHeaderPlugins) {
            this.setHeader(plugin, (arg_0, arg_1) -> ((org.apache.hc.core5.http.HttpRequest)request).setHeader(arg_0, arg_1));
        }
    }

    public void process(HttpRequest request, org.apache.http.protocol.HttpContext context) {
        for (DatabaseCustomHeaderSupplier plugin : this.databaseHeaderPlugins) {
            this.setHeader(plugin, (arg_0, arg_1) -> ((HttpRequest)request).setHeader(arg_0, arg_1));
        }
    }

    private void setHeader(DatabaseCustomHeaderSupplier plugin, HeaderConsumer headerConsumer) {
        CustomHeader header = plugin.getSearchDatabaseCustomHeader();
        headerConsumer.accept(header.key(), header.value());
    }

    private static interface HeaderConsumer {
        public void accept(String var1, String var2);
    }
}

