/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.connect.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.camunda.search.connect.configuration.ConnectConfiguration;
import io.camunda.search.connect.jackson.CustomInstantDeserializer;
import io.camunda.search.connect.jackson.CustomOffsetDateTimeDeserializer;
import io.camunda.search.connect.jackson.CustomOffsetDateTimeSerializer;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class JacksonConfiguration {
    private final ConnectConfiguration configuration;

    public JacksonConfiguration(ConnectConfiguration configuration) {
        this.configuration = configuration;
    }

    public ObjectMapper createObjectMapper() {
        DateTimeFormatter dateTimeFormatter = this.createDateTimeFormatter();
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(OffsetDateTime.class, (JsonSerializer)new CustomOffsetDateTimeSerializer(dateTimeFormatter));
        javaTimeModule.addDeserializer(OffsetDateTime.class, (JsonDeserializer)new CustomOffsetDateTimeDeserializer(dateTimeFormatter));
        javaTimeModule.addDeserializer(Instant.class, (JsonDeserializer)new CustomInstantDeserializer());
        return new ObjectMapper().registerModules(new Module[]{javaTimeModule, new Jdk8Module()}).configure(SerializationFeature.INDENT_OUTPUT, false).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false).configure(JsonParser.Feature.ALLOW_COMMENTS, true).setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.ANY).setVisibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.ANY).setVisibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.ANY).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.CREATOR, JsonAutoDetect.Visibility.ANY);
    }

    public DateTimeFormatter createDateTimeFormatter() {
        return DateTimeFormatter.ofPattern(this.configuration.getDateFormat());
    }
}

