/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.connect.configuration;

public enum DatabaseType {
    ELASTICSEARCH("elasticsearch"),
    OPENSEARCH("opensearch"),
    RDBMS("rdbms"),
    NONE("none");

    private final String type;

    private DatabaseType(String type) {
        this.type = type;
    }

    public static DatabaseType from(String type) {
        return DatabaseType.valueOf(type.toUpperCase());
    }

    public boolean isElasticSearch() {
        return this.equals((Object)ELASTICSEARCH);
    }

    public boolean isOpenSearch() {
        return this.equals((Object)OPENSEARCH);
    }

    public boolean isRdbms() {
        return this.equals((Object)RDBMS);
    }

    public boolean isNone() {
        return this.equals((Object)NONE);
    }

    public String toString() {
        return this.type;
    }
}

